/*
 * Decompiled with CFR 0.152.
 */
package com.wys.utils.uuid;

public class SnowIdUtils {
    public static long uniqueLong() {
        return SnowFlake.SNOW_FLAKE.nextId();
    }

    public static String uniqueLongHex() {
        return String.format("%016x", SnowIdUtils.uniqueLong());
    }

    private static class SnowFlake {
        private static final SnowFlake SNOW_FLAKE = new SnowFlake();
        private final long START_TIMESTAMP = 1557489395327L;
        private final long SEQUENCE_BIT = 5L;
        private final long MACHINE_BIT = 5L;
        private final long TIMESTAMP_LEFT = 10L;
        private final long MAX_SEQUENCE = 31L;
        private final long MAX_MACHINE_ID = 31L;
        private long machineIdPart;
        private long sequence = 0L;
        private long lastStamp = -1L;

        private SnowFlake() {
            long localIp = 4321L;
            this.machineIdPart = (localIp & 0x1FL) << 5;
        }

        public synchronized long nextId() {
            long currentStamp = this.timeGen();
            if (currentStamp < this.lastStamp) {
                throw new RuntimeException(String.format("\u65f6\u949f\u5df2\u7ecf\u56de\u62e8.  Refusing to generate id for %d milliseconds", this.lastStamp - currentStamp));
            }
            if (currentStamp == this.lastStamp) {
                this.sequence = this.sequence + 1L & 0x1FL;
                if (this.sequence == 0L) {
                    currentStamp = this.getNextMill();
                }
            } else {
                this.sequence = 0L;
            }
            this.lastStamp = currentStamp;
            return currentStamp - 1557489395327L << 10 | this.machineIdPart | this.sequence;
        }

        private long getNextMill() {
            long mill = this.timeGen();
            while (mill <= this.lastStamp) {
                mill = this.timeGen();
            }
            return mill;
        }

        protected long timeGen() {
            return System.currentTimeMillis();
        }
    }
}

