/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.core;

import cn.cliveyuan.robin.generator.core.CodeGeneratorXmlConfig;
import cn.cliveyuan.robin.generator.core.Entity;
import cn.cliveyuan.robin.generator.core.ExtensionParam;
import cn.cliveyuan.robin.generator.core.GenerateParam;
import cn.cliveyuan.robin.generator.core.Generator;
import cn.cliveyuan.robin.generator.core.GeneratorContext;
import cn.cliveyuan.robin.generator.core.GeneratorEnum;
import cn.cliveyuan.robin.generator.util.FreemarkerUtils;
import cn.cliveyuan.robin.generator.util.ReflectUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorChain
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(GeneratorChain.class);
    private final List<Generator> generators = new ArrayList<Generator>();
    private int index = 0;

    public GeneratorChain() {
        this.init();
    }

    @Override
    public void generate(GeneratorContext context, GeneratorChain generatorChain) {
        if (this.generators.size() == this.index) {
            return;
        }
        Generator generator = this.generators.get(this.index);
        log.info("GeneratorChain generate: generator={}, index={}", (Object)generator.getClass().getSimpleName(), (Object)this.index);
        ++this.index;
        generator.generate(context, generatorChain);
    }

    private void init() {
        log.info("GeneratorChain init START");
        for (GeneratorEnum value : GeneratorEnum.values()) {
            this.generators.add((Generator)ReflectUtils.newInstance(value.getClazz()));
        }
        log.info("GeneratorChain init END, generators.size={}", (Object)this.generators.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerate(GenerateParam generateParam) {
        try {
            String templatePath;
            CodeGeneratorXmlConfig.MapperGeneratorConfig generatorConfig = generateParam.getGeneratorConfig();
            if (generatorConfig.isDisabled()) {
                log.info("doGenerate skip the module: {}", (Object)generatorConfig.getModuleName());
                return;
            }
            GeneratorEnum generatorEnum = GeneratorEnum.valueOf(generateParam.getGenerator());
            GeneratorContext context = generateParam.getContext();
            this.setFileName(generateParam);
            String codeFilePath = this.getCodeFilePath(generatorConfig);
            Map<String, Object> paramMap = this.getParamMap(context);
            String customizedTemplatePath = generatorConfig.getTemplatePath();
            String string = templatePath = StringUtils.isNotBlank((CharSequence)customizedTemplatePath) ? customizedTemplatePath : generatorEnum.getTemplatePath();
            if (Objects.nonNull(generateParam.getBeforeExtensionHandle())) {
                generateParam.getBeforeExtensionHandle().accept(ExtensionParam.builder().context(generateParam.getContext()).paramMap(paramMap).codeFilePath(codeFilePath).build());
            }
            context.getEntityList().forEach(entity -> this.generateFile(paramMap, templatePath, codeFilePath, (Entity)entity, generatorEnum));
        }
        finally {
            this.generate(generateParam.getContext(), this);
        }
    }

    public String getSuffix(CodeGeneratorXmlConfig.MapperGeneratorConfig generatorConfig, Generator generator) {
        return this.getSuffix(generatorConfig, GeneratorEnum.valueOf(generator));
    }

    public String getSuffix(CodeGeneratorXmlConfig.MapperGeneratorConfig generatorConfig, GeneratorEnum generatorEnum) {
        String suffix = generatorEnum.getDefaultSuffix();
        if (StringUtils.isNotBlank((CharSequence)generatorConfig.getSuffix())) {
            suffix = generatorConfig.getSuffix();
        }
        return suffix;
    }

    private void setFileName(GenerateParam generateParam) {
        Function<Entity, String> function = generateParam.getFileNameFunction();
        List<Entity> entities = generateParam.getContext().getEntityList();
        if (Objects.nonNull(function)) {
            entities.forEach(x -> x.setFileName((String)function.apply((Entity)x)));
        } else {
            String suffix = this.getSuffix(generateParam.getGeneratorConfig(), generateParam.getGenerator());
            entities.forEach(x -> x.setFileName(x.getUpperCamelName() + suffix));
        }
    }

    private String getCodeFilePath(CodeGeneratorXmlConfig.MapperGeneratorConfig generatorConfig) {
        String targetPackage = generatorConfig.getTargetPackage();
        String projectPath = System.getProperty("user.dir");
        String codePath = generatorConfig.getCodePath();
        String packagePath = targetPackage.replace(".", "/");
        return String.format("%s/%s/%s", projectPath, codePath, packagePath);
    }

    private Map<String, Object> getParamMap(GeneratorContext context) {
        CodeGeneratorXmlConfig xmlConfig = context.getXmlConfig();
        CodeGeneratorXmlConfig.MapperGeneratorConfig javaModelGenerator = xmlConfig.getJavaModelGenerator();
        CodeGeneratorXmlConfig.MapperGeneratorConfig javaClientGenerator = xmlConfig.getJavaClientGenerator();
        CodeGeneratorXmlConfig.MapperGeneratorConfig serviceGenerator = xmlConfig.getServiceGenerator();
        CodeGeneratorXmlConfig.MapperGeneratorConfig controllerGenerator = xmlConfig.getControllerGenerator();
        CodeGeneratorXmlConfig.MapperGeneratorConfig dtoGenerator = xmlConfig.getDtoGenerator();
        String dtoSuffix = this.getSuffix(dtoGenerator, GeneratorEnum.DTO);
        String mapperSuffix = this.getSuffix(javaClientGenerator, GeneratorEnum.MAPPER_JAVA);
        String serviceSuffix = this.getSuffix(serviceGenerator, GeneratorEnum.SERVICE);
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("entityPackage", javaModelGenerator.getTargetPackage());
        paramMap.put("mapperPackage", javaClientGenerator.getTargetPackage());
        paramMap.put("mapperImplPackage", javaClientGenerator.getTargetPackage() + ".impl");
        paramMap.put("servicePackage", serviceGenerator.getTargetPackage());
        paramMap.put("serviceImplPackage", serviceGenerator.getTargetPackage() + ".impl");
        paramMap.put("controllerPackage", controllerGenerator.getTargetPackage());
        paramMap.put("dtoPackage", dtoGenerator.getTargetPackage());
        paramMap.put("baseConfig", xmlConfig.getBaseConfig());
        paramMap.put("dtoSuffix", dtoSuffix);
        paramMap.put("mapperSuffix", mapperSuffix);
        paramMap.put("serviceSuffix", serviceSuffix);
        return paramMap;
    }

    private void generateFile(Map<String, Object> paramMap, String ftlPath, String codeFilePath, Entity entity, GeneratorEnum generatorEnum) {
        String fileName = entity.getFileName() + generatorEnum.getFileType().getExtension();
        paramMap.put("entity", entity);
        String codeContent = FreemarkerUtils.parseTemplate(ftlPath, paramMap);
        String filePath = String.format("%s/%s", codeFilePath, fileName);
        this.writeStringToFile(filePath, codeContent, generatorEnum.isOverwrite());
    }

    private void writeStringToFile(String filePath, String data, boolean overwrite) {
        try {
            File file = new File(filePath);
            if (file.exists() && !overwrite) {
                log.debug("The file is exist, skip creating it: {}", (Object)file.getName());
                return;
            }
            FileUtils.writeStringToFile((File)file, (String)data, (Charset)StandardCharsets.UTF_8);
            log.debug("The file was created successfully: {}", (Object)file.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

