/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.core;

import cn.cliveyuan.robin.generator.core.CodeGeneratorXmlConfig;
import cn.cliveyuan.robin.generator.core.Entity;
import cn.cliveyuan.robin.generator.core.Field;
import cn.cliveyuan.robin.generator.core.GeneratorContext;
import cn.cliveyuan.robin.generator.db.ColumnInfo;
import cn.cliveyuan.robin.generator.db.ConnectionFactory;
import cn.cliveyuan.robin.generator.db.JdbcType;
import cn.cliveyuan.robin.generator.db.JdbcTypeResolver;
import cn.cliveyuan.robin.generator.db.MysqlTableIntrospect;
import cn.cliveyuan.robin.generator.db.TableInfo;
import cn.cliveyuan.robin.generator.db.TableIntrospect;
import cn.cliveyuan.robin.generator.util.CollectionUtils;
import cn.cliveyuan.robin.generator.util.GeneratorUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class GeneratorContextResolver {
    private static final Logger log = LoggerFactory.getLogger(GeneratorContextResolver.class);
    private static final String CONFIG_XML_NAME = "code-generator.xml";
    private static final String DEFAULT_CONFIG_FILE_PATH = "/code-generator.xml";
    private CodeGeneratorXmlConfig xmlConfig;
    private TableIntrospect tableIntrospect;

    public GeneratorContext resolve(String configFilePath) {
        log.info("GeneratorContextResolver resolving START, configFilePath={}", (Object)configFilePath);
        CodeGeneratorXmlConfig xmlConfig = this.parseXmlConfig(configFilePath);
        List<Entity> entityList = this.parseEntityList(xmlConfig);
        GeneratorContext generatorContext = new GeneratorContext();
        generatorContext.setEntityList(entityList);
        generatorContext.setXmlConfig(xmlConfig);
        this.closeTableIntrospect();
        log.info("GeneratorContextResolver resolving END, entityList.size={}", (Object)entityList.size());
        return generatorContext;
    }

    private void initTableIntrospect() {
        CodeGeneratorXmlConfig.JdbcConnection jdbcConnection = this.xmlConfig.getJdbcConnection();
        Connection connection = ConnectionFactory.createConnection(jdbcConnection.getDriverClass(), jdbcConnection.getConnectionURL(), jdbcConnection.getUsername(), jdbcConnection.getPassword());
        this.tableIntrospect = new MysqlTableIntrospect(connection);
    }

    private void closeTableIntrospect() {
        this.tableIntrospect.closeConnection();
    }

    private List<Entity> parseEntityList(CodeGeneratorXmlConfig xmlConfig) {
        List<CodeGeneratorXmlConfig.Table> tables = xmlConfig.getTables();
        return tables.stream().map(this::table2Entity).collect(Collectors.toList());
    }

    private Entity table2Entity(CodeGeneratorXmlConfig.Table table) {
        String suffix;
        TableInfo tableInfo = this.tableIntrospect.introspect(table.getTableName());
        Entity entity = new Entity();
        String lowerCamelName = GeneratorUtils.getLowerCamelName(tableInfo.getName());
        String upperCamelName = StringUtils.capitalize((String)lowerCamelName);
        String entityName = table.getEntityObjectName();
        String string = suffix = StringUtils.isNotBlank((CharSequence)table.getEntityObjectSuffix()) ? table.getEntityObjectSuffix() : "";
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            lowerCamelName = GeneratorUtils.getLowerCamelName(entityName);
            upperCamelName = StringUtils.capitalize((String)entityName);
        }
        entityName = upperCamelName + suffix;
        entity.setLowerCamelName(lowerCamelName);
        entity.setEntityName(entityName);
        entity.setTableName(tableInfo.getName());
        entity.setComment(tableInfo.getComment());
        entity.setUpperCamelName(upperCamelName);
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(this.xmlConfig.getFixedField());
        fields.addAll(this.column2Field(table, tableInfo.getColumns()));
        this.matchIdType(fields, tableInfo.getColumns());
        entity.setFields(fields);
        entity.setHasBigDecimalField(this.hasBigDecimalField(entity.getFields()));
        return entity;
    }

    private void matchIdType(List<Field> fields, List<ColumnInfo> columns) {
        columns.stream().filter(x -> Objects.equals("id", x.getName())).findAny().ifPresent(idColumn -> {
            fields.removeIf(x -> Objects.equals("id", x.getColumnName()));
            Field idField = this.convertColumnInfo2Field((ColumnInfo)idColumn);
            idField.setNullable(true);
            idField.setComment("ID \u4e3b\u952e");
            idField.setMarkColumnName(false);
            idField.setPrimaryKey(true);
            fields.add(0, idField);
        });
    }

    private List<Field> column2Field(CodeGeneratorXmlConfig.Table table, List<ColumnInfo> columns) {
        return columns.stream().filter(x -> !table.getIgnoreColumns().contains(x.getName())).map(this::convertColumnInfo2Field).collect(Collectors.toList());
    }

    private Field convertColumnInfo2Field(ColumnInfo columnInfo) {
        Field field = new Field();
        field.setJdbcType(JdbcTypeResolver.resolve(columnInfo.getType(), columnInfo.getLength()));
        String lowerCamelName = GeneratorUtils.getLowerCamelName(columnInfo.getName());
        if (SourceVersion.isKeyword(lowerCamelName)) {
            lowerCamelName = lowerCamelName + "$";
        }
        field.setLowerCamelName(lowerCamelName);
        field.setUpperCamelName(StringUtils.capitalize((String)lowerCamelName));
        field.setColumnName(columnInfo.getName());
        field.setLength(columnInfo.getLength());
        field.setNullable(columnInfo.getNullable());
        field.setComment(columnInfo.getComment());
        field.setMarkColumnName(!Objects.equals(field.getLowerCamelName(), field.getColumnName()));
        return field;
    }

    private boolean hasBigDecimalField(List<Field> fields) {
        return fields.stream().anyMatch(x -> JdbcType.DECIMAL.equals((Object)x.getJdbcType()));
    }

    private CodeGeneratorXmlConfig parseXmlConfig(String configFilePath) {
        if (StringUtils.isBlank((CharSequence)configFilePath)) {
            configFilePath = DEFAULT_CONFIG_FILE_PATH;
        }
        log.info("GeneratorContextResolver: configFilePath={}", (Object)configFilePath);
        try {
            CodeGeneratorXmlConfig config;
            this.xmlConfig = config = new CodeGeneratorXmlConfig();
            InputStream xmlInputStream = this.getClass().getResourceAsStream(configFilePath);
            if (Objects.isNull(xmlInputStream)) {
                log.info("can't find file in resource path, try to find in file system");
                File file = new File(configFilePath);
                xmlInputStream = FileUtils.openInputStream((File)file);
            }
            Assert.notNull((Object)xmlInputStream, (String)("code generator config file is not exist: " + configFilePath));
            SAXReader reader = new SAXReader();
            reader.setValidation(true);
            Document document = reader.read(xmlInputStream);
            Element rootElement = document.getRootElement();
            config.setBaseConfig(this.getBaseConfig(rootElement));
            config.setJdbcConnection(this.getJdbcConnection(rootElement));
            this.initTableIntrospect();
            config.setJavaModelGenerator(this.getMapperGeneratorConfig(rootElement, "javaModelGenerator"));
            config.setSqlMapGenerator(this.getMapperGeneratorConfig(rootElement, "sqlMapGenerator"));
            config.setJavaClientGenerator(this.getMapperGeneratorConfig(rootElement, "javaClientGenerator"));
            config.setServiceGenerator(this.getMapperGeneratorConfig(rootElement, "serviceGenerator"));
            config.setControllerGenerator(this.getMapperGeneratorConfig(rootElement, "controllerGenerator"));
            config.setDtoGenerator(this.getMapperGeneratorConfig(rootElement, "dtoGenerator"));
            this.verifyDtoGenerator(config);
            config.setTables(this.getTables(rootElement));
            return config;
        }
        catch (Exception e) {
            log.error("Fail to parse xml file: " + configFilePath, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void verifyDtoGenerator(CodeGeneratorXmlConfig config) {
        CodeGeneratorXmlConfig.MapperGeneratorConfig controllerGenerator = config.getControllerGenerator();
        CodeGeneratorXmlConfig.MapperGeneratorConfig dtoGenerator = config.getDtoGenerator();
        if (!controllerGenerator.isDisabled()) {
            Assert.isTrue((!dtoGenerator.isDisabled() ? 1 : 0) != 0, (String)"DTO\u751f\u6210\u914d\u7f6e\u672a\u751f\u6548, \u8bf7\u68c0\u67e5'dtoGenerator'\u6807\u7b7e(\u751f\u6210controller\u65f6DTO\u4e5f\u9700\u8981\u5f00\u542f)");
        }
    }

    private CodeGeneratorXmlConfig.BaseConfig getBaseConfig(Element rootElement) {
        CodeGeneratorXmlConfig.BaseConfig baseConfig = CodeGeneratorXmlConfig.BaseConfig.builder().build();
        Element baseConfigEl = this.getNullableElement(rootElement, "baseConfig");
        if (Objects.nonNull(baseConfigEl)) {
            Iterator iterator = baseConfigEl.elementIterator("property");
            while (iterator.hasNext()) {
                Element property = (Element)iterator.next();
                String name = this.getAttributeValue(property, "name");
                if (StringUtils.isBlank((CharSequence)name)) continue;
                switch (name) {
                    case "enableLombok": {
                        baseConfig.setEnableLombok("true".equalsIgnoreCase(property.getStringValue()));
                        break;
                    }
                    case "enableSwagger": {
                        baseConfig.setEnableSwagger("true".equalsIgnoreCase(property.getStringValue()));
                        break;
                    }
                    case "enableValidation": {
                        baseConfig.setEnableValidation("true".equalsIgnoreCase(property.getStringValue()));
                        break;
                    }
                    case "enableReadWriteSeparation": {
                        baseConfig.setEnableReadWriteSeparation("true".equalsIgnoreCase(property.getStringValue()));
                        break;
                    }
                    case "disableUpdatingMapperXml": {
                        baseConfig.setDisableUpdatingMapperXml("true".equalsIgnoreCase(property.getStringValue()));
                        break;
                    }
                    case "enableMapperAnnotation": {
                        baseConfig.setEnableMapperAnnotation("true".equalsIgnoreCase(property.getStringValue()));
                    }
                }
            }
        }
        return baseConfig;
    }

    private CodeGeneratorXmlConfig.JdbcConnection getJdbcConnection(Element rootElement) {
        Element jdbcConnection = this.getElement(rootElement, "jdbcConnection");
        String host = this.getAttributeValueNonBlank(jdbcConnection, "host");
        String database = this.getAttributeValueNonBlank(jdbcConnection, "database");
        String tinyInt1isBit = this.getAttributeValue(jdbcConnection, "tinyInt1isBit", true);
        String queryString = "";
        if ("false".equalsIgnoreCase(tinyInt1isBit)) {
            queryString = "?tinyInt1isBit=false";
        }
        String connectionURL = String.format("jdbc:mysql://%s/%s%s", host, database, queryString);
        return CodeGeneratorXmlConfig.JdbcConnection.builder().driverClass(this.getAttributeValueNonBlank(jdbcConnection, "driverClass")).connectionURL(connectionURL).username(this.getAttributeValue(jdbcConnection, "username")).password(this.getAttributeValue(jdbcConnection, "password")).build();
    }

    private List<CodeGeneratorXmlConfig.Table> getTables(Element rootElement) {
        ArrayList tables = Lists.newArrayList();
        Element tableEls = this.getElement(rootElement, "tables");
        String all = this.getAttributeValue(tableEls, "all", true);
        boolean allTables = "true".equalsIgnoreCase(all);
        String createTimeColumn = this.getAttributeValue(tableEls, "createTimeColumn", true);
        String updateTimeColumn = this.getAttributeValue(tableEls, "updateTimeColumn", true);
        String entityObjectSuffix = this.getAttributeValue(tableEls, "entityObjectSuffix", true);
        Set<String> globalIgnoreColumnSet = this.getIgnoreColumnSet(tableEls);
        String primaryKeyColumn = "id";
        ArrayList<String> fixedColumns = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)createTimeColumn)) {
            createTimeColumn = "created_at";
        }
        if (StringUtils.isBlank((CharSequence)updateTimeColumn)) {
            updateTimeColumn = "updated_at";
        }
        fixedColumns.add(primaryKeyColumn);
        fixedColumns.add(createTimeColumn);
        fixedColumns.add(updateTimeColumn);
        this.xmlConfig.setFixedColumns(fixedColumns);
        ArrayList<Field> fixedFields = new ArrayList<Field>();
        fixedFields.add(this.getPrimaryKeyField(primaryKeyColumn));
        fixedFields.add(this.getDateField(createTimeColumn, "\u521b\u5efa\u65f6\u95f4"));
        fixedFields.add(this.getDateField(updateTimeColumn, "\u4fee\u6539\u65f6\u95f4"));
        this.xmlConfig.setFixedField(fixedFields);
        globalIgnoreColumnSet.addAll(fixedColumns);
        if (allTables) {
            List<String> tableNames = this.tableIntrospect.getAllTables();
            tableNames.forEach(tableName -> tables.add(CodeGeneratorXmlConfig.Table.builder().tableName((String)tableName).ignoreColumns(globalIgnoreColumnSet).build()));
        } else {
            Iterator iterator = tableEls.elementIterator("table");
            while (iterator.hasNext()) {
                Element tableEl = (Element)iterator.next();
                HashSet<String> tableIgnoreColumnSet = new HashSet<String>(globalIgnoreColumnSet);
                tableIgnoreColumnSet.addAll(this.getIgnoreColumnSet(tableEl));
                tables.add(CodeGeneratorXmlConfig.Table.builder().tableName(this.getAttributeValue(tableEl, "tableName")).entityObjectName(this.getAttributeValue(tableEl, "entityObjectName", true)).entityObjectSuffix(entityObjectSuffix).ignoreColumns(tableIgnoreColumnSet).build());
            }
        }
        return tables;
    }

    private Field getPrimaryKeyField(String primaryKeyColumn) {
        Field field = new Field();
        field.setJdbcType(JdbcType.LONG);
        String lowerCamelName = GeneratorUtils.getLowerCamelName(primaryKeyColumn);
        if (SourceVersion.isKeyword(lowerCamelName)) {
            lowerCamelName = lowerCamelName + "$";
        }
        field.setLowerCamelName(lowerCamelName);
        field.setUpperCamelName(StringUtils.capitalize((String)lowerCamelName));
        field.setColumnName(primaryKeyColumn);
        field.setLength(20);
        field.setNullable(true);
        field.setComment("ID \u4e3b\u952e");
        field.setMarkColumnName(false);
        field.setPrimaryKey(true);
        return field;
    }

    private Field getDateField(String column, String comment) {
        Field field = new Field();
        field.setJdbcType(JdbcType.DATE);
        String lowerCamelName = GeneratorUtils.getLowerCamelName(column);
        if (SourceVersion.isKeyword(lowerCamelName)) {
            lowerCamelName = lowerCamelName + "$";
        }
        field.setLowerCamelName(lowerCamelName);
        field.setUpperCamelName(StringUtils.capitalize((String)lowerCamelName));
        field.setColumnName(column);
        field.setLength(19);
        field.setNullable(true);
        field.setComment(comment);
        field.setMarkColumnName(!Objects.equals(field.getLowerCamelName(), field.getColumnName()));
        field.setSwaggerHidden(true);
        field.setIgnoreSaving(true);
        return field;
    }

    private Set<String> getIgnoreColumnSet(Element element) {
        String ignoreColumns = this.getAttributeValue(element, "ignoreColumns", true);
        HashSet<String> ignoreColumnSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)ignoreColumns)) {
            ignoreColumnSet.addAll(CollectionUtils.listOf(ignoreColumns.split(",")));
        }
        return ignoreColumnSet;
    }

    private CodeGeneratorXmlConfig.MapperGeneratorConfig getMapperGeneratorConfig(Element rootElement, String nodeName) {
        Element element = rootElement.element(nodeName);
        if (Objects.isNull(element)) {
            return CodeGeneratorXmlConfig.MapperGeneratorConfig.builder().disabled(true).moduleName(nodeName).build();
        }
        String disabledValue = this.getAttributeValue(element, "disabled", true);
        return CodeGeneratorXmlConfig.MapperGeneratorConfig.builder().disabled("true".equalsIgnoreCase(disabledValue)).targetPackage(this.getAttributeValue(element, "targetPackage")).codePath(this.getAttributeValue(element, "codePath")).templatePath(this.getAttributeValue(element, "templatePath", true)).suffix(this.getAttributeValue(element, "suffix", true)).moduleName(nodeName).build();
    }

    private Element getElement(Element element, String name) {
        Element childElement = this.getNullableElement(element, name);
        Assert.notNull((Object)childElement, (String)("Element '" + name + "' is not exist"));
        return childElement;
    }

    private Element getNullableElement(Element element, String name) {
        return element.element(name);
    }

    private String getAttributeValueNonBlank(Element element, String attributeName) {
        String attributeValue = this.getAttributeValue(element, attributeName, false);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)attributeValue), (String)("Attribute '" + attributeName + "' is empty string"));
        return attributeValue;
    }

    private String getAttributeValue(Element element, String attributeName) {
        return this.getAttributeValue(element, attributeName, false);
    }

    private String getAttributeValue(Element element, String attributeName, boolean nullable) {
        Attribute attribute = element.attribute(attributeName);
        if (!nullable) {
            Assert.notNull((Object)attribute, (String)("Attribute '" + attributeName + "' is not exist"));
        }
        return Objects.nonNull(attribute) ? attribute.getValue() : null;
    }
}

