/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.core;

import cn.cliveyuan.robin.generator.core.FileType;
import cn.cliveyuan.robin.generator.core.Generator;
import cn.cliveyuan.robin.generator.generator.ControllerGenerator;
import cn.cliveyuan.robin.generator.generator.DTOGenerator;
import cn.cliveyuan.robin.generator.generator.EntityGenerator;
import cn.cliveyuan.robin.generator.generator.MapperJavaGenerator;
import cn.cliveyuan.robin.generator.generator.MapperJavaImplGenerator;
import cn.cliveyuan.robin.generator.generator.MapperXmlGenerator;
import cn.cliveyuan.robin.generator.generator.ServiceGenerator;
import cn.cliveyuan.robin.generator.generator.ServiceImplGenerator;
import java.util.Arrays;
import java.util.Objects;

public enum GeneratorEnum {
    ENTITY(EntityGenerator.class, FileType.JAVA, "templates/entity.java.ftl", true, ""),
    MAPPER_XML(MapperXmlGenerator.class, FileType.XML, "templates/mapper.xml.ftl", false, "Mapper"),
    MAPPER_JAVA(MapperJavaGenerator.class, FileType.JAVA, "templates/mapper.java.ftl", false, "Mapper"),
    MAPPER_JAVA_IMPL(MapperJavaImplGenerator.class, FileType.JAVA, "templates/mapperimpl.java.ftl", false, "Mapper"),
    SERVICE(ServiceGenerator.class, FileType.JAVA, "templates/service.java.ftl", false, "Service"),
    SERVICE_IMPL(ServiceImplGenerator.class, FileType.JAVA, "templates/serviceimpl.java.ftl", false, "Service"),
    DTO(DTOGenerator.class, FileType.JAVA, "templates/dto.java.ftl", false, "DTO"),
    CONTROLLER(ControllerGenerator.class, FileType.JAVA, "templates/controller.java.ftl", false, "Controller");

    private final Class<?> clazz;
    private final FileType fileType;
    private final String templatePath;
    private final boolean overwrite;
    private final String defaultSuffix;

    public static GeneratorEnum valueOf(Generator generator) {
        return Arrays.stream(GeneratorEnum.values()).filter(x -> Objects.equals(generator.getClass(), x.getClazz())).findAny().orElseThrow(() -> new IllegalArgumentException("GeneratorEnum not fund: " + generator.getClass()));
    }

    private GeneratorEnum(Class<?> clazz, FileType fileType, String templatePath, boolean overwrite, String defaultSuffix) {
        this.clazz = clazz;
        this.fileType = fileType;
        this.templatePath = templatePath;
        this.overwrite = overwrite;
        this.defaultSuffix = defaultSuffix;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }
}

