/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private static final String QUESTION_MARK = "?";
    private static final String AND_MARK = "&";
    private static final String URL_PARAMS = "useInformationSchema=true";

    public static Connection createConnection(String driver, String url, String username, String password) {
        try {
            Class.forName(driver);
            url = url.contains(QUESTION_MARK) ? url + AND_MARK.concat(URL_PARAMS) : url + QUESTION_MARK.concat(URL_PARAMS);
            return DriverManager.getConnection(url, username, password);
        }
        catch (ClassNotFoundException | SQLException e) {
            log.error("createConnection", (Throwable)e);
            throw new RuntimeException(String.format("Fail to create connection with driver=%s,url=%s,username=%s,password=%s", driver, url, username, password));
        }
    }
}

