/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.db;

import cn.cliveyuan.robin.generator.db.ColumnInfo;
import cn.cliveyuan.robin.generator.db.TableInfo;
import cn.cliveyuan.robin.generator.db.TableIntrospect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTableIntrospect
implements TableIntrospect {
    private static final Logger log = LoggerFactory.getLogger(MysqlTableIntrospect.class);
    private final Connection connection;

    public MysqlTableIntrospect(Connection connection) {
        this.connection = connection;
    }

    @Override
    public TableInfo introspect(String tableName) {
        try {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName(tableName);
            DatabaseMetaData metaData = this.connection.getMetaData();
            try (ResultSet tableRs = metaData.getTables(this.connection.getCatalog(), null, tableName, null);){
                if (tableRs.next()) {
                    String remarks = tableRs.getString("REMARKS");
                    if (StringUtils.isBlank((CharSequence)remarks)) {
                        remarks = tableName;
                    }
                    tableInfo.setComment(remarks);
                }
            }
            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
            tableInfo.setColumns(columns);
            try (ResultSet columnRs = metaData.getColumns(this.connection.getCatalog(), null, tableName, null);){
                while (columnRs.next()) {
                    String columnName = columnRs.getString("COLUMN_NAME");
                    String typeName = columnRs.getString("TYPE_NAME");
                    int columnSize = columnRs.getInt("COLUMN_SIZE");
                    int nullable = columnRs.getInt("NULLABLE");
                    String comment = columnRs.getString("REMARKS");
                    ColumnInfo column = new ColumnInfo();
                    column.setName(columnName);
                    column.setType(typeName);
                    column.setLength(columnSize);
                    column.setNullable(nullable == 1);
                    column.setComment(StringUtils.isNotBlank((CharSequence)comment) ? comment : columnName);
                    columns.add(column);
                }
            }
            return tableInfo;
        }
        catch (SQLException e) {
            log.error("introspect", (Throwable)e);
            throw new RuntimeException("Fail to introspect table: " + tableName);
        }
    }

    @Override
    public List<String> getAllTables() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            ResultSet tableRs = metaData.getTables(this.connection.getCatalog(), null, null, null);
            while (tableRs.next()) {
                list.add(tableRs.getString("TABLE_NAME"));
            }
        }
        catch (SQLException e) {
            log.error("introspect", (Throwable)e);
            throw new RuntimeException(e);
        }
        return list;
    }

    @Override
    public void closeConnection() {
        if (Objects.nonNull(this.connection)) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

