/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.generator;

import cn.cliveyuan.robin.generator.core.ExtensionParam;
import cn.cliveyuan.robin.generator.core.GenerateParam;
import cn.cliveyuan.robin.generator.core.Generator;
import cn.cliveyuan.robin.generator.core.GeneratorChain;
import cn.cliveyuan.robin.generator.core.GeneratorContext;
import cn.cliveyuan.robin.generator.core.GeneratorEnum;
import cn.cliveyuan.robin.generator.util.FileContentModifyUtils;
import cn.cliveyuan.robin.generator.util.FreemarkerUtils;
import java.io.File;
import java.util.Map;

public class MapperXmlGenerator
implements Generator {
    @Override
    public void generate(GeneratorContext context, GeneratorChain generatorChain) {
        generatorChain.doGenerate(GenerateParam.builder().generator(this).context(context).generatorConfig(context.getXmlConfig().getSqlMapGenerator()).beforeExtensionHandle(this::modifyExistMapperXml).build());
    }

    private void modifyExistMapperXml(ExtensionParam extensionParam) {
        extensionParam.getContext().getEntityList().forEach(entity -> {
            String fileName = entity.getFileName() + GeneratorEnum.MAPPER_XML.getFileType().getExtension();
            String filePath = String.format("%s/%s", extensionParam.getCodeFilePath(), fileName);
            File file = new File(filePath);
            if (!file.exists()) {
                return;
            }
            Map<String, Object> paramMap = extensionParam.getParamMap();
            paramMap.put("entity", entity);
            this.modifyBaseColumnList(paramMap, filePath);
            this.modifyBaseResultMap(paramMap, filePath);
        });
    }

    private void modifyBaseColumnList(Map<String, Object> paramMap, String filePath) {
        this.modifyContent(paramMap, filePath, "templates/segment/base_column_list.inc.ftl", "<sql id=\"BaseColumnList\">", "</sql>");
    }

    private void modifyBaseResultMap(Map<String, Object> paramMap, String filePath) {
        this.modifyContent(paramMap, filePath, "templates/segment/base_result_map.inc.ftl", "<resultMap id=\"BaseResultMap\"", "</resultMap>");
    }

    private void modifyContent(Map<String, Object> paramMap, String filePath, String ftlPath, String start, String end) {
        String codeContent = FreemarkerUtils.parseTemplate(ftlPath, paramMap);
        FileContentModifyUtils.modify(filePath, start, end, String.format("    %s", codeContent.trim()));
    }
}

