/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.impl;

import cn.cliveyuan.robin.generator.RobinGenerator;
import cn.cliveyuan.robin.generator.core.GeneratorChain;
import cn.cliveyuan.robin.generator.core.GeneratorContext;
import cn.cliveyuan.robin.generator.core.GeneratorContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisGenerator
implements RobinGenerator {
    private static final Logger log = LoggerFactory.getLogger(MybatisGenerator.class);
    private final String configFilePath;

    public MybatisGenerator(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    @Override
    public void generate() {
        log.info("MybatisGenerator.generate [START] customized configFilePath is {}", (Object)this.configFilePath);
        long start = System.currentTimeMillis();
        GeneratorContextResolver generatorContextResolver = new GeneratorContextResolver();
        GeneratorContext generatorContext = generatorContextResolver.resolve(this.configFilePath);
        GeneratorChain generatorChain = new GeneratorChain();
        generatorChain.generate(generatorContext, generatorChain);
        log.info("MybatisGenerator.generate [SUCCESS] cost {}ms", (Object)(System.currentTimeMillis() - start));
    }

    public static MybatisGeneratorBuilder builder() {
        return new MybatisGeneratorBuilder();
    }

    public static class MybatisGeneratorBuilder {
        private String configFilePath;

        MybatisGeneratorBuilder() {
        }

        public MybatisGeneratorBuilder configFilePath(String configFilePath) {
            this.configFilePath = configFilePath;
            return this;
        }

        public MybatisGenerator build() {
            return new MybatisGenerator(this.configFilePath);
        }

        public String toString() {
            return "MybatisGenerator.MybatisGeneratorBuilder(configFilePath=" + this.configFilePath + ")";
        }
    }
}

