/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentModifyUtils {
    private static final Logger log = LoggerFactory.getLogger(FileContentModifyUtils.class);

    public static void modify(String fileName, String startMark, String endMark, String content) {
        try {
            int i;
            ArrayList<String> newLines = new ArrayList<String>();
            List<String> lines = Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8);
            int start = -1;
            int end = -1;
            for (i = 0; i < lines.size(); ++i) {
                String line = lines.get(i).trim();
                if (line.startsWith(startMark)) {
                    start = i;
                }
                if (!line.contains(endMark)) continue;
                end = i;
                if (start >= 0) break;
            }
            log.info("FileContentModifyUtils.modify start={}, end={}", (Object)start, (Object)end);
            if (start >= 0 && end >= 0) {
                for (i = 0; i < lines.size(); ++i) {
                    if (i >= start && i <= end) continue;
                    newLines.add(lines.get(i));
                }
                newLines.add(start, content);
                Files.write(Paths.get(fileName, new String[0]), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
            } else {
                log.info("FileContentModifyUtils.modify can't find the segment to modify");
            }
        }
        catch (IOException e) {
            log.error("FileContentModifyUtils.modify error", (Throwable)e);
        }
    }
}

