/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.robin.generator.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtils {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerUtils.class);
    private static final String ENCODING = "UTF-8";

    public static String parseTemplate(String filePath, Map<String, Object> dataModelMap) {
        try {
            int index = filePath.lastIndexOf(47);
            String basePackagePath = filePath.substring(0, index + 1);
            String fileName = filePath.substring(index + 1);
            Template template = FreemarkerUtils.getTemplateByName(basePackagePath, fileName);
            StringWriter strWriter = new StringWriter();
            template.setOutputEncoding(ENCODING);
            template.process(dataModelMap, (Writer)strWriter);
            return strWriter.toString();
        }
        catch (Exception e) {
            logger.error("parseTemplate Exc", (Throwable)e);
            throw new IllegalArgumentException("freemarker \u6a21\u677f\u89e3\u6790\u5931\u8d25");
        }
    }

    private static Template getTemplateByName(String basePackagePath, String fileName) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setTagSyntax(2);
        configuration.setClassLoaderForTemplateLoading(FreemarkerUtils.class.getClassLoader(), basePackagePath);
        configuration.setEncoding(Locale.ENGLISH, ENCODING);
        configuration.setDefaultEncoding(ENCODING);
        configuration.setOutputEncoding(ENCODING);
        return configuration.getTemplate(fileName);
    }
}

