package ${controllerPackage};

import ${entityPackage}.${entity.entityName};
import ${dtoPackage}.${entity.upperCamelName}${dtoSuffix};
import ${servicePackage}.${entity.upperCamelName}${serviceSuffix};
import cn.cliveyuan.robin.base.condition.PageQueryExample;
import cn.cliveyuan.robin.base.common.PageQueryRequest;
import cn.cliveyuan.robin.base.util.BeanCopyUtils;
import cn.cliveyuan.robin.base.common.ApiResponse;
import cn.cliveyuan.robin.base.common.Pagination;

[#if baseConfig.enableSwagger]
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
[/#if]
[#if baseConfig.enableValidation]
import org.springframework.validation.annotation.Validated;
[/#if]
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * ${entity.comment} 控制器
 */
@RestController
@RequestMapping("/${entity.lowerCamelName}")
[#if baseConfig.enableSwagger]
@Api(tags = "${entity.comment}接口")
[/#if]
public class ${entity.fileName} {

    @Resource
    private ${entity.upperCamelName}${serviceSuffix} ${entity.lowerCamelName}${serviceSuffix};

    @PostMapping("save")
[#if baseConfig.enableSwagger]
    @ApiOperation("保存")
[/#if]
    public ApiResponse<Boolean> save([#if baseConfig.enableValidation]@Validated[/#if] ${entity.upperCamelName}${dtoSuffix} request) {
        return ApiResponse.success(${entity.lowerCamelName}${serviceSuffix}.save(BeanCopyUtils.copy(request, ${entity.entityName}.class)) > 0);
    }

    @PostMapping("delete")
[#if baseConfig.enableSwagger]
    @ApiOperation("删除")
[/#if]
    public ApiResponse<Boolean> delete(Long id) {
        return ApiResponse.success(${entity.lowerCamelName}${serviceSuffix}.delete(id) > 0);
    }

    @PostMapping("get")
[#if baseConfig.enableSwagger]
    @ApiOperation("获取")
[/#if]
    public ApiResponse<${entity.upperCamelName}${dtoSuffix}> get(Long id) {
        return ApiResponse.success(BeanCopyUtils.copy(${entity.lowerCamelName}${serviceSuffix}.get(id), ${entity.upperCamelName}${dtoSuffix}.class));
    }

    @PostMapping("page")
[#if baseConfig.enableSwagger]
    @ApiOperation("分页查询")
[/#if]
    public ApiResponse<Pagination<${entity.upperCamelName}${dtoSuffix}>> page(@RequestBody PageQueryRequest<${entity.upperCamelName}${dtoSuffix}> request) {
        return ApiResponse.success(BeanCopyUtils.copyPagination(${entity.lowerCamelName}${serviceSuffix}.page(new PageQueryExample<>(request, ${entity.entityName}.class)), ${entity.upperCamelName}${dtoSuffix}.class));
    }
}
