/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.peigenlpy.mica.client;

import com.gitee.peigenlpy.mica.client.MqttClientCustomizer;
import java.util.ArrayList;
import java.util.List;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.core.client.MqttClientSubscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;

public class MqttClientTemplate {
    private static final Logger log = LoggerFactory.getLogger(MqttClientTemplate.class);
    public static final String DEFAULT_CLIENT_TEMPLATE_BEAN = "mqttClientTemplate";
    private final MqttClientCreator clientCreator;
    private final IMqttClientConnectListener clientConnectListener;
    private final MqttClientCustomizer customizer;
    private final List<MqttClientSubscription> tempSubscriptionList;
    private MqttClient client;

    public MqttClientTemplate(MqttClientCreator clientCreator) {
        this(clientCreator, null, null);
    }

    public MqttClientTemplate(MqttClientCreator clientCreator, IMqttClientConnectListener clientConnectListener) {
        this(clientCreator, clientConnectListener, null);
    }

    public MqttClientTemplate(MqttClientCreator clientCreator, IMqttClientConnectListener clientConnectListener, MqttClientCustomizer customizer) {
        this.clientCreator = clientCreator;
        this.clientConnectListener = clientConnectListener;
        this.customizer = customizer;
        this.tempSubscriptionList = new ArrayList<MqttClientSubscription>();
    }

    public MqttClient subQos0(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_MOST_ONCE, listener);
    }

    public MqttClient subQos1(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_LEAST_ONCE, listener);
    }

    public MqttClient subQos2(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.EXACTLY_ONCE, listener);
    }

    public MqttClient subscribe(MqttQoS mqttQoS, String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, mqttQoS, listener);
    }

    public MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilters, mqttQoS, listener);
    }

    public MqttClient subscribe(List<MqttClientSubscription> subscriptionList) {
        return this.client.subscribe(subscriptionList);
    }

    public MqttClient unSubscribe(String ... topicFilter) {
        return this.client.unSubscribe(topicFilter);
    }

    public MqttClient unSubscribe(List<String> topicFilters) {
        return this.client.unSubscribe(topicFilters);
    }

    public boolean publish(String topic, byte[] payload) {
        return this.client.publish(topic, payload, MqttQoS.AT_MOST_ONCE);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos) {
        return this.client.publish(topic, payload, qos, false);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, boolean retain) {
        return this.client.publish(topic, payload, qos, retain);
    }

    public void reconnect() {
        this.client.reconnect();
    }

    public boolean reconnect(String ip, int port) {
        return this.client.reconnect(ip, port);
    }

    public boolean disconnect() {
        return this.client.disconnect();
    }

    public TioClient getTioClient() {
        return this.client.getTioClient();
    }

    public MqttClientCreator getClientCreator() {
        return this.clientCreator;
    }

    public TioClientConfig getClientTioConfig() {
        return this.client.getClientTioConfig();
    }

    public ClientChannelContext getContext() {
        return this.client.getContext();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public boolean isDisconnected() {
        return this.client.isDisconnected();
    }

    public MqttClient getMqttClient() {
        return this.client;
    }

    public void addSubscriptionList(String[] topicFilters, MqttQoS qos, IMqttClientMessageListener messageListener) {
        for (String topicFilter : topicFilters) {
            this.tempSubscriptionList.add(new MqttClientSubscription(qos, topicFilter, messageListener));
        }
    }

    public void connect() {
        Integer timeout;
        this.clientCreator.connectListener(this.clientConnectListener);
        if (this.customizer != null) {
            this.customizer.customize(this.clientCreator);
        }
        if ((timeout = this.clientCreator.getTimeout()) == null) {
            this.clientCreator.timeout(3);
        }
        this.client = this.clientCreator.connectSync();
        this.client.subscribe(this.tempSubscriptionList);
        this.tempSubscriptionList.clear();
        log.info("mqtt client connect...");
    }

    public void destroy() {
        this.client.stop();
    }
}

