/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.peigenlpy.mica.client.config;

import com.gitee.peigenlpy.mica.client.config.MqttClientProperties;
import com.gitee.peigenlpy.mica.client.event.SolonEventMqttClientConnectListener;
import java.nio.charset.StandardCharsets;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Import;
import org.noear.solon.lang.Nullable;

@Configuration
@Import(scanPackages={"com.gitee.peigenlpy.mica"})
public class MqttClientConfiguration {
    @Bean
    @Condition(onMissingBean=IMqttClientConnectListener.class)
    public IMqttClientConnectListener solonEventMqttClientConnectListener() {
        return new SolonEventMqttClientConnectListener();
    }

    @Bean
    public MqttClientCreator mqttClientCreator(MqttClientProperties properties) {
        MqttClientProperties.WillMessage willMessage;
        MqttClientProperties.Ssl ssl;
        MqttClientCreator clientCreator = MqttClient.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).username(properties.getUserName()).password(properties.getPassword()).clientId(properties.getClientId()).readBufferSize((int)properties.getReadBufferSize().toBytes()).maxBytesInMessage((int)properties.getMaxBytesInMessage().toBytes()).maxClientIdLength(properties.getMaxClientIdLength()).keepAliveSecs(properties.getKeepAliveSecs()).reconnect(properties.isReconnect()).reInterval(properties.getReInterval()).retryCount(properties.getRetryCount()).reSubscribeBatchSize(properties.getReSubscribeBatchSize()).version(properties.getVersion()).cleanSession(properties.isCleanSession()).bufferAllocator(properties.getBufferAllocator()).statEnable(properties.isStatEnable());
        Integer timeout = properties.getTimeout();
        if (timeout != null && timeout > 0) {
            clientCreator.timeout(timeout.intValue());
        }
        if (properties.isDebug()) {
            clientCreator.debug();
        }
        if ((ssl = properties.getSsl()).isEnabled()) {
            clientCreator.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass());
        }
        if ((willMessage = properties.getWillMessage()) != null && MqttClientConfiguration.hasText(willMessage.getTopic())) {
            clientCreator.willMessage(builder -> {
                builder.topic(willMessage.getTopic()).qos(willMessage.getQos()).retain(willMessage.isRetain());
                if (MqttClientConfiguration.hasText(willMessage.getMessage())) {
                    builder.message(willMessage.getMessage().getBytes(StandardCharsets.UTF_8));
                }
            });
        }
        return clientCreator;
    }

    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && MqttClientConfiguration.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

