/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.peigenlpy.mica.client.integration;

import cn.hutool.core.util.ReflectUtil;
import com.gitee.peigenlpy.mica.client.MqttClientCustomizer;
import com.gitee.peigenlpy.mica.client.MqttClientSubscribe;
import com.gitee.peigenlpy.mica.client.MqttClientTemplate;
import com.gitee.peigenlpy.mica.client.config.MqttClientConfiguration;
import com.gitee.peigenlpy.mica.client.config.MqttClientProperties;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientSession;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;
import org.noear.solon.Solon;
import org.noear.solon.SolonProps;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttClientPluginImpl
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(MqttClientPluginImpl.class);
    final List<ExtractorClassTag<MqttClientSubscribe>> subscribeClassTags = new ArrayList<ExtractorClassTag<MqttClientSubscribe>>();
    final List<ExtractorMethodTag<MqttClientSubscribe>> subscribeMethodTags = new ArrayList<ExtractorMethodTag<MqttClientSubscribe>>();

    public void start(AopContext context) throws Throwable {
        Solon.context().beanBuilderAdd(MqttClientSubscribe.class, (clz, beanWrap, anno) -> this.subscribeClassTags.add(new ExtractorClassTag<MqttClientSubscribe>(clz, beanWrap, (MqttClientSubscribe)anno)));
        Solon.context().beanExtractorAdd(MqttClientSubscribe.class, (bw, method, anno) -> this.subscribeMethodTags.add(new ExtractorMethodTag<MqttClientSubscribe>(bw, method, (MqttClientSubscribe)anno)));
        context.lifecycle(Integer.MAX_VALUE, () -> {
            context.beanMake(MqttClientConfiguration.class);
            MqttClientCreator clientCreator = (MqttClientCreator)context.getBean(MqttClientCreator.class);
            IMqttClientConnectListener clientConnectListener = (IMqttClientConnectListener)context.getBean(IMqttClientConnectListener.class);
            MqttClientCustomizer customizers = (MqttClientCustomizer)context.getBean(MqttClientCustomizer.class);
            MqttClientTemplate clientTemplate = new MqttClientTemplate(clientCreator, clientConnectListener, customizers);
            BeanWrap mqttClientTemplateWrap = context.wrap(MqttClientTemplate.class, (Object)clientTemplate);
            context.putWrap("mqttClientTemplate", mqttClientTemplateWrap);
            context.putWrap(MqttClientTemplate.class, mqttClientTemplateWrap);
            IMqttClientSession clientSession = (IMqttClientSession)context.getBean(IMqttClientSession.class);
            clientCreator.clientSession(clientSession);
            this.subscribeDetector();
            MqttClientProperties properties = (MqttClientProperties)context.getBean(MqttClientProperties.class);
            if (properties.isEnabled()) {
                clientTemplate.connect();
            }
        });
    }

    private void subscribeDetector() {
        this.subscribeClassTags.stream().forEach(each -> {
            MqttClientSubscribe anno = (MqttClientSubscribe)each.getAnno();
            MqttClientTemplate clientTemplate = this.getMqttClientTemplate(anno);
            String[] topicFilters = this.getTopicFilters(anno);
            IMqttClientMessageListener iMqttClientMessageListener = (IMqttClientMessageListener)each.getBeanWrap().get();
            clientTemplate.addSubscriptionList(topicFilters, anno.qos(), iMqttClientMessageListener);
        });
        this.subscribeMethodTags.stream().forEach(each -> {
            MqttClientSubscribe anno = (MqttClientSubscribe)each.getAnno();
            MqttClientTemplate clientTemplate = this.getMqttClientTemplate(anno);
            String[] topicFilters = this.getTopicFilters(anno);
            clientTemplate.addSubscriptionList(topicFilters, anno.qos(), (ctx, topic, message, payload) -> ReflectUtil.invoke((Object)each.getBw().get(), (Method)each.getMethod(), (Object[])new Object[]{topic, payload}));
        });
    }

    public void stop() throws Throwable {
        MqttClientTemplate clientTemplate = (MqttClientTemplate)Solon.context().getBean(MqttClientTemplate.class);
        clientTemplate.destroy();
    }

    private MqttClientTemplate getMqttClientTemplate(MqttClientSubscribe anno) {
        return (MqttClientTemplate)Solon.context().getBean(anno.clientTemplateBean());
    }

    private String[] getTopicFilters(MqttClientSubscribe anno) {
        return (String[])Arrays.stream(anno.value()).map(arg_0 -> ((SolonProps)Solon.cfg()).getByParse(arg_0)).map(TopicUtil::getTopicFilter).toArray(String[]::new);
    }

    private class ExtractorMethodTag<T> {
        BeanWrap bw;
        Method method;
        T anno;

        public BeanWrap getBw() {
            return this.bw;
        }

        public Method getMethod() {
            return this.method;
        }

        public T getAnno() {
            return this.anno;
        }

        public void setBw(BeanWrap bw) {
            this.bw = bw;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public void setAnno(T anno) {
            this.anno = anno;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtractorMethodTag)) {
                return false;
            }
            ExtractorMethodTag other = (ExtractorMethodTag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BeanWrap this$bw = this.getBw();
            BeanWrap other$bw = other.getBw();
            if (this$bw == null ? other$bw != null : !this$bw.equals(other$bw)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            T this$anno = this.getAnno();
            T other$anno = other.getAnno();
            return !(this$anno == null ? other$anno != null : !this$anno.equals(other$anno));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtractorMethodTag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BeanWrap $bw = this.getBw();
            result = result * 59 + ($bw == null ? 43 : $bw.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            T $anno = this.getAnno();
            result = result * 59 + ($anno == null ? 43 : $anno.hashCode());
            return result;
        }

        public String toString() {
            return "MqttClientPluginImpl.ExtractorMethodTag(bw=" + this.getBw() + ", method=" + this.getMethod() + ", anno=" + this.getAnno() + ")";
        }

        public ExtractorMethodTag(BeanWrap bw, Method method, T anno) {
            this.bw = bw;
            this.method = method;
            this.anno = anno;
        }
    }

    private class ExtractorClassTag<T> {
        Class<?> clz;
        BeanWrap beanWrap;
        T anno;

        public Class<?> getClz() {
            return this.clz;
        }

        public BeanWrap getBeanWrap() {
            return this.beanWrap;
        }

        public T getAnno() {
            return this.anno;
        }

        public void setClz(Class<?> clz) {
            this.clz = clz;
        }

        public void setBeanWrap(BeanWrap beanWrap) {
            this.beanWrap = beanWrap;
        }

        public void setAnno(T anno) {
            this.anno = anno;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtractorClassTag)) {
                return false;
            }
            ExtractorClassTag other = (ExtractorClassTag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clz = this.getClz();
            Class<?> other$clz = other.getClz();
            if (this$clz == null ? other$clz != null : !this$clz.equals(other$clz)) {
                return false;
            }
            BeanWrap this$beanWrap = this.getBeanWrap();
            BeanWrap other$beanWrap = other.getBeanWrap();
            if (this$beanWrap == null ? other$beanWrap != null : !this$beanWrap.equals(other$beanWrap)) {
                return false;
            }
            T this$anno = this.getAnno();
            T other$anno = other.getAnno();
            return !(this$anno == null ? other$anno != null : !this$anno.equals(other$anno));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtractorClassTag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clz = this.getClz();
            result = result * 59 + ($clz == null ? 43 : $clz.hashCode());
            BeanWrap $beanWrap = this.getBeanWrap();
            result = result * 59 + ($beanWrap == null ? 43 : $beanWrap.hashCode());
            T $anno = this.getAnno();
            result = result * 59 + ($anno == null ? 43 : $anno.hashCode());
            return result;
        }

        public String toString() {
            return "MqttClientPluginImpl.ExtractorClassTag(clz=" + this.getClz() + ", beanWrap=" + this.getBeanWrap() + ", anno=" + this.getAnno() + ")";
        }

        public ExtractorClassTag(Class<?> clz, BeanWrap beanWrap, T anno) {
            this.clz = clz;
            this.beanWrap = beanWrap;
            this.anno = anno;
        }
    }
}

