/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.peigenlpy.mica.server.config;

import cn.hutool.core.io.unit.DataSize;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.tio.core.ssl.ClientAuth;
import org.tio.utils.buffer.ByteBufferAllocator;

@Inject(value="${mqtt.server}", required=false)
@Configuration
public class MqttServerProperties {
    public static final String PREFIX = "mqtt.server";
    private boolean enabled = true;
    private String name = "Mica-Mqtt-Server";
    private String ip;
    private int port = 1883;
    private MqttAuth auth = new MqttAuth();
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private DataSize readBufferSize = DataSize.ofBytes((long)8192L);
    private DataSize maxBytesInMessage = DataSize.ofBytes((long)0xA00000L);
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private Ssl ssl = new Ssl();
    private boolean debug = false;
    private int maxClientIdLength = 64;
    private int webPort = 8083;
    private boolean websocketEnable = true;
    private boolean httpEnable = false;
    private HttpBasicAuth httpBasicAuth = new HttpBasicAuth();
    private String nodeName;
    private boolean statEnable = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public MqttAuth getAuth() {
        return this.auth;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public DataSize getReadBufferSize() {
        return this.readBufferSize;
    }

    public DataSize getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public boolean isWebsocketEnable() {
        return this.websocketEnable;
    }

    public boolean isHttpEnable() {
        return this.httpEnable;
    }

    public HttpBasicAuth getHttpBasicAuth() {
        return this.httpBasicAuth;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuth(MqttAuth auth) {
        this.auth = auth;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setKeepaliveBackoff(float keepaliveBackoff) {
        this.keepaliveBackoff = keepaliveBackoff;
    }

    public void setReadBufferSize(DataSize readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setMaxBytesInMessage(DataSize maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
    }

    public void setBufferAllocator(ByteBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMaxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
    }

    public void setWebPort(int webPort) {
        this.webPort = webPort;
    }

    public void setWebsocketEnable(boolean websocketEnable) {
        this.websocketEnable = websocketEnable;
    }

    public void setHttpEnable(boolean httpEnable) {
        this.httpEnable = httpEnable;
    }

    public void setHttpBasicAuth(HttpBasicAuth httpBasicAuth) {
        this.httpBasicAuth = httpBasicAuth;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setStatEnable(boolean statEnable) {
        this.statEnable = statEnable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttServerProperties)) {
            return false;
        }
        MqttServerProperties other = (MqttServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (Float.compare(this.getKeepaliveBackoff(), other.getKeepaliveBackoff()) != 0) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.getMaxClientIdLength() != other.getMaxClientIdLength()) {
            return false;
        }
        if (this.getWebPort() != other.getWebPort()) {
            return false;
        }
        if (this.isWebsocketEnable() != other.isWebsocketEnable()) {
            return false;
        }
        if (this.isHttpEnable() != other.isHttpEnable()) {
            return false;
        }
        if (this.isStatEnable() != other.isStatEnable()) {
            return false;
        }
        Long this$heartbeatTimeout = this.getHeartbeatTimeout();
        Long other$heartbeatTimeout = other.getHeartbeatTimeout();
        if (this$heartbeatTimeout == null ? other$heartbeatTimeout != null : !((Object)this$heartbeatTimeout).equals(other$heartbeatTimeout)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        MqttAuth this$auth = this.getAuth();
        MqttAuth other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        DataSize this$readBufferSize = this.getReadBufferSize();
        DataSize other$readBufferSize = other.getReadBufferSize();
        if (this$readBufferSize == null ? other$readBufferSize != null : !this$readBufferSize.equals(other$readBufferSize)) {
            return false;
        }
        DataSize this$maxBytesInMessage = this.getMaxBytesInMessage();
        DataSize other$maxBytesInMessage = other.getMaxBytesInMessage();
        if (this$maxBytesInMessage == null ? other$maxBytesInMessage != null : !this$maxBytesInMessage.equals(other$maxBytesInMessage)) {
            return false;
        }
        ByteBufferAllocator this$bufferAllocator = this.getBufferAllocator();
        ByteBufferAllocator other$bufferAllocator = other.getBufferAllocator();
        if (this$bufferAllocator == null ? other$bufferAllocator != null : !this$bufferAllocator.equals(other$bufferAllocator)) {
            return false;
        }
        Ssl this$ssl = this.getSsl();
        Ssl other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !this$ssl.equals(other$ssl)) {
            return false;
        }
        HttpBasicAuth this$httpBasicAuth = this.getHttpBasicAuth();
        HttpBasicAuth other$httpBasicAuth = other.getHttpBasicAuth();
        if (this$httpBasicAuth == null ? other$httpBasicAuth != null : !this$httpBasicAuth.equals(other$httpBasicAuth)) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        return !(this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + Float.floatToIntBits(this.getKeepaliveBackoff());
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + this.getMaxClientIdLength();
        result = result * 59 + this.getWebPort();
        result = result * 59 + (this.isWebsocketEnable() ? 79 : 97);
        result = result * 59 + (this.isHttpEnable() ? 79 : 97);
        result = result * 59 + (this.isStatEnable() ? 79 : 97);
        Long $heartbeatTimeout = this.getHeartbeatTimeout();
        result = result * 59 + ($heartbeatTimeout == null ? 43 : ((Object)$heartbeatTimeout).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        MqttAuth $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        DataSize $readBufferSize = this.getReadBufferSize();
        result = result * 59 + ($readBufferSize == null ? 43 : $readBufferSize.hashCode());
        DataSize $maxBytesInMessage = this.getMaxBytesInMessage();
        result = result * 59 + ($maxBytesInMessage == null ? 43 : $maxBytesInMessage.hashCode());
        ByteBufferAllocator $bufferAllocator = this.getBufferAllocator();
        result = result * 59 + ($bufferAllocator == null ? 43 : $bufferAllocator.hashCode());
        Ssl $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : $ssl.hashCode());
        HttpBasicAuth $httpBasicAuth = this.getHttpBasicAuth();
        result = result * 59 + ($httpBasicAuth == null ? 43 : $httpBasicAuth.hashCode());
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        return result;
    }

    public String toString() {
        return "MqttServerProperties(enabled=" + this.isEnabled() + ", name=" + this.getName() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", auth=" + this.getAuth() + ", heartbeatTimeout=" + this.getHeartbeatTimeout() + ", keepaliveBackoff=" + this.getKeepaliveBackoff() + ", readBufferSize=" + this.getReadBufferSize() + ", maxBytesInMessage=" + this.getMaxBytesInMessage() + ", bufferAllocator=" + this.getBufferAllocator() + ", ssl=" + this.getSsl() + ", debug=" + this.isDebug() + ", maxClientIdLength=" + this.getMaxClientIdLength() + ", webPort=" + this.getWebPort() + ", websocketEnable=" + this.isWebsocketEnable() + ", httpEnable=" + this.isHttpEnable() + ", httpBasicAuth=" + this.getHttpBasicAuth() + ", nodeName=" + this.getNodeName() + ", statEnable=" + this.isStatEnable() + ")";
    }

    public static class MqttAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class HttpBasicAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Ssl {
        private boolean enabled = false;
        private String keystorePath;
        private String keystorePass;
        private String truststorePath;
        private String truststorePass;
        private ClientAuth clientAuth = ClientAuth.NONE;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePass() {
            return this.keystorePass;
        }

        public String getTruststorePath() {
            return this.truststorePath;
        }

        public String getTruststorePass() {
            return this.truststorePass;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
        }

        public void setKeystorePass(String keystorePass) {
            this.keystorePass = keystorePass;
        }

        public void setTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
        }

        public void setTruststorePass(String truststorePass) {
            this.truststorePass = truststorePass;
        }

        public void setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }
    }
}

