/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.peigenlpy.mica.server.integration;

import cn.hutool.core.util.ObjUtil;
import com.gitee.peigenlpy.mica.server.MqttServerCustomizer;
import com.gitee.peigenlpy.mica.server.MqttServerTemplate;
import com.gitee.peigenlpy.mica.server.config.MqttServerConfiguration;
import com.gitee.peigenlpy.mica.server.config.MqttServerProperties;
import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.MqttServerCreator;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerAuthHandler;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerPublishPermission;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerUniqueIdService;
import net.dreamlu.iot.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import net.dreamlu.iot.mqtt.core.server.event.IMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttMessageListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttSessionListener;
import net.dreamlu.iot.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import net.dreamlu.iot.mqtt.core.server.store.IMqttMessageStore;
import net.dreamlu.iot.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttServerPluginImpl
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(MqttServerPluginImpl.class);
    private volatile boolean running = false;

    public void start(AopContext context) throws Throwable {
        context.lifecycle(Integer.MAX_VALUE, () -> {
            context.beanMake(MqttServerConfiguration.class);
            MqttServerCreator serverCreator = (MqttServerCreator)context.getBean(MqttServerCreator.class);
            MqttServerProperties properties = (MqttServerProperties)context.getBean(MqttServerProperties.class);
            IMqttServerAuthHandler authHandlerImpl = (IMqttServerAuthHandler)context.getBean(IMqttServerAuthHandler.class);
            IMqttServerUniqueIdService uniqueIdService = (IMqttServerUniqueIdService)context.getBean(IMqttServerUniqueIdService.class);
            IMqttServerSubscribeValidator subscribeValidator = (IMqttServerSubscribeValidator)context.getBean(IMqttServerSubscribeValidator.class);
            IMqttServerPublishPermission publishPermission = (IMqttServerPublishPermission)context.getBean(IMqttServerPublishPermission.class);
            IMqttMessageDispatcher messageDispatcher = (IMqttMessageDispatcher)context.getBean(IMqttMessageDispatcher.class);
            IMqttMessageStore messageStore = (IMqttMessageStore)context.getBean(IMqttMessageStore.class);
            IMqttSessionManager sessionManager = (IMqttSessionManager)context.getBean(IMqttSessionManager.class);
            IMqttSessionListener sessionListener = (IMqttSessionListener)context.getBean(IMqttSessionListener.class);
            IMqttMessageListener messageListener = (IMqttMessageListener)context.getBean(IMqttMessageListener.class);
            IMqttConnectStatusListener connectStatusListener = (IMqttConnectStatusListener)context.getBean(IMqttConnectStatusListener.class);
            IMqttMessageInterceptor messageInterceptor = (IMqttMessageInterceptor)context.getBean(IMqttMessageInterceptor.class);
            MqttServerCustomizer customizers = (MqttServerCustomizer)context.getBean(MqttServerCustomizer.class);
            serverCreator.messageListener(messageListener);
            MqttServerProperties.MqttAuth mqttAuth = properties.getAuth();
            if (ObjUtil.isNull((Object)authHandlerImpl)) {
                DefaultMqttServerAuthHandler authHandler = mqttAuth.isEnable() ? new DefaultMqttServerAuthHandler(mqttAuth.getUsername(), mqttAuth.getPassword()) : null;
                serverCreator.authHandler((IMqttServerAuthHandler)authHandler);
            } else {
                serverCreator.authHandler(authHandlerImpl);
            }
            if (ObjUtil.isNotNull((Object)uniqueIdService)) {
                serverCreator.uniqueIdService(uniqueIdService);
            }
            if (ObjUtil.isNotNull((Object)subscribeValidator)) {
                serverCreator.subscribeValidator(subscribeValidator);
            }
            if (ObjUtil.isNotNull((Object)publishPermission)) {
                serverCreator.publishPermission(publishPermission);
            }
            if (ObjUtil.isNotNull((Object)messageDispatcher)) {
                serverCreator.messageDispatcher(messageDispatcher);
            }
            if (ObjUtil.isNotNull((Object)messageStore)) {
                serverCreator.messageStore(messageStore);
            }
            if (ObjUtil.isNotNull((Object)sessionManager)) {
                serverCreator.sessionManager(sessionManager);
            }
            if (ObjUtil.isNotNull((Object)sessionListener)) {
                serverCreator.sessionListener(sessionListener);
            }
            if (ObjUtil.isNotNull((Object)connectStatusListener)) {
                serverCreator.connectStatusListener(connectStatusListener);
            }
            if (ObjUtil.isNotNull((Object)messageInterceptor)) {
                serverCreator.addInterceptor(messageInterceptor);
            }
            if (ObjUtil.isNotNull((Object)customizers)) {
                customizers.customize(serverCreator);
            }
            MqttServer mqttServer = serverCreator.build();
            MqttServerTemplate mqttServerTemplate = new MqttServerTemplate(mqttServer);
            context.wrapAndPut(MqttServerTemplate.class, (Object)mqttServerTemplate);
            if (properties.isEnabled() && !this.running) {
                this.running = mqttServerTemplate.getMqttServer().start();
                log.info("mqtt server start...");
            }
        });
    }

    public void stop() {
        if (this.running) {
            MqttServerTemplate mqttServerTemplate = (MqttServerTemplate)Solon.context().getBean(MqttServerTemplate.class);
            mqttServerTemplate.getMqttServer().stop();
            log.info("mqtt server stop...");
        }
    }
}

