/*
 * Decompiled with CFR 0.152.
 */
package com.reger.datasource.aspect;

import com.reger.datasource.annotation.DataSourceChange;
import com.reger.datasource.core.Proxy;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483648)
public class DataSourceAspect {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceAspect.class);

    @Around(value="@annotation(com.reger.datasource.annotation.DataSourceChange)", argNames="point")
    public Object doAround(final ProceedingJoinPoint point) throws Throwable {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        Class<?> targetClass = point.getTarget().getClass();
        Method targetMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
        DataSourceChange annotation = (DataSourceChange)AnnotationUtils.findAnnotation((Method)targetMethod, DataSourceChange.class);
        if (annotation == null) {
            return point.proceed();
        }
        Proxy.SwitchExecute<Object> execute = new Proxy.SwitchExecute<Object>(){

            @Override
            public Object run() throws Throwable {
                return point.proceed();
            }
        };
        if (annotation.slave()) {
            logger.debug("\u6ce8\u89e3\u5230\u4ece\u5e93\u6267\u884c");
            return Proxy.slave(execute);
        }
        logger.debug("\u6ce8\u89e3\u5230\u4e3b\u5e93\u6267\u884c");
        return Proxy.master(execute);
    }
}

