/*
 * Decompiled with CFR 0.152.
 */
package com.reger.datasource.config;

import com.reger.datasource.aspect.DataSourceAspect;
import com.reger.datasource.core.AbstractDataBaseBean;
import com.reger.datasource.core.DataSourceInvalidRetry;
import com.reger.datasource.core.Dialect;
import com.reger.datasource.core.Mapper;
import com.reger.datasource.core.Order;
import com.reger.datasource.properties.DaoProperties;
import com.reger.datasource.properties.DruidProperties;
import com.reger.datasource.properties.MybatisNodeProperties;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.code.Style;

@EnableTransactionManagement(proxyTargetClass=true, order=-2147483648)
public class DataSourceAutoConfiguration
extends AbstractDataBaseBean
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    static Logger log = LoggerFactory.getLogger(DataSourceAutoConfiguration.class);
    ConfigurableEnvironment environment;

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DaoProperties druidConfig = this.getDruidConfig("spring.mybatis", DaoProperties.class);
        DruidProperties defaultConfig = this.getDruidConfig("spring.druid.default", DruidProperties.class);
        Configuration configuration = druidConfig.getConfiguration();
        Map<String, MybatisNodeProperties> druidNodeConfigs = druidConfig.getNodes();
        if (druidNodeConfigs == null || druidNodeConfigs.isEmpty()) {
            throw new RuntimeException("\u81f3\u5c11\u9700\u8981\u914d\u7f6e\u4e00\u4e2aDataBase(\u914d\u7f6eDataBase\u53c2\u6570\u5728spring.mybatis.nodes)");
        }
        for (Map.Entry<String, MybatisNodeProperties> entry : this.setPrimary(druidNodeConfigs).entrySet()) {
            String druidNodeName = entry.getKey();
            MybatisNodeProperties druidNodeConfig = entry.getValue();
            try {
                Configuration _configuration = configuration == null ? new Configuration() : super.cloneConfiguration(configuration);
                this.registryBean(druidNodeName, druidNodeConfig, defaultConfig, _configuration, registry);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<String, MybatisNodeProperties> setPrimary(Map<String, MybatisNodeProperties> druidNodeConfigs) {
        int primarys = 0;
        MybatisNodeProperties defDruidNode = null;
        for (Map.Entry<String, MybatisNodeProperties> entry : druidNodeConfigs.entrySet()) {
            MybatisNodeProperties druidNode = entry.getValue();
            if (druidNode != null && druidNode.isPrimary() && ++primarys > 1) {
                druidNode.setPrimary(false);
            }
            if (druidNode == null || defDruidNode != null) continue;
            defDruidNode = druidNode;
        }
        if (primarys == 0 && defDruidNode != null) {
            defDruidNode.setPrimary(true);
        }
        return druidNodeConfigs;
    }

    private <T> T getDruidConfig(String prefix, Class<T> claz) {
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(claz);
        factory.setPropertySources((PropertySources)this.environment.getPropertySources());
        factory.setConversionService((ConversionService)this.environment.getConversionService());
        factory.setIgnoreInvalidFields(false);
        factory.setIgnoreUnknownFields(true);
        factory.setIgnoreNestedProperties(false);
        factory.setTargetName(prefix);
        try {
            factory.bindPropertiesToTarget();
            return (T)factory.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void registryBean(String druidNodeName, MybatisNodeProperties nodeProperties, DruidProperties defaultProperties, Configuration configuration, BeanDefinitionRegistry registry) {
        String basepackage;
        Mapper mappers;
        if (nodeProperties == null) {
            return;
        }
        String mapperPackage = nodeProperties.getMapperPackage();
        String typeAliasesPackage = nodeProperties.getTypeAliasesPackage();
        String dbType = super.getDbType(nodeProperties.getMaster(), defaultProperties);
        Order order = nodeProperties.getOrder();
        Dialect dialect = nodeProperties.getDialect();
        Style style = nodeProperties.getStyle();
        if (null == dialect) {
            dialect = Dialect.valoueOfName(dbType);
        }
        if ((mappers = nodeProperties.getMapper()) == null) {
            mappers = Mapper.valueOfDialect(dialect);
        }
        if (StringUtils.isEmpty((Object)(basepackage = nodeProperties.getBasePackage()))) {
            log.warn("BasePackage\u4e3a\u7a7a\uff0cdb\u914d\u7f6e\u5f02\u5e38,\u5f53\u524d\u914d\u7f6e\u6570\u636e\u6e90\u5bf9\u8c61\u7684\u540d\u5b57{}", (Object)druidNodeName);
            basepackage = "";
        }
        boolean primary = nodeProperties.isPrimary();
        String dataSourceName = druidNodeName + "DataSource";
        String jdbcTemplateName = druidNodeName + "JdbcTemplate";
        String transactionManagerName = druidNodeName;
        String sqlSessionFactoryBeanName = druidNodeName + "RegerSqlSessionFactoryBean";
        String scannerConfigurerName = druidNodeName + "RegerScannerConfigurer";
        AbstractBeanDefinition dataSource = super.createDataSource(nodeProperties, defaultProperties, dataSourceName);
        AbstractBeanDefinition jdbcTemplate = super.createJdbcTemplate(dataSourceName);
        AbstractBeanDefinition transactionManager = super.createTransactionManager(dataSourceName);
        AbstractBeanDefinition sqlSessionFactoryBean = super.createSqlSessionFactoryBean(dataSourceName, mapperPackage, typeAliasesPackage, dialect, configuration);
        AbstractBeanDefinition scannerConfigurer = super.createScannerConfigurerBean(sqlSessionFactoryBeanName, basepackage, mappers, order, style);
        dataSource.setLazyInit(true);
        dataSource.setPrimary(primary);
        dataSource.setScope("singleton");
        jdbcTemplate.setLazyInit(true);
        jdbcTemplate.setPrimary(primary);
        jdbcTemplate.setScope("singleton");
        transactionManager.setLazyInit(true);
        transactionManager.setPrimary(primary);
        transactionManager.setScope("singleton");
        sqlSessionFactoryBean.setLazyInit(true);
        sqlSessionFactoryBean.setPrimary(primary);
        sqlSessionFactoryBean.setScope("singleton");
        scannerConfigurer.setLazyInit(true);
        scannerConfigurer.setPrimary(primary);
        scannerConfigurer.setScope("singleton");
        registry.registerBeanDefinition(dataSourceName, (BeanDefinition)dataSource);
        registry.registerBeanDefinition(jdbcTemplateName, (BeanDefinition)jdbcTemplate);
        registry.registerBeanDefinition(transactionManagerName, (BeanDefinition)transactionManager);
        registry.registerBeanDefinition(sqlSessionFactoryBeanName, (BeanDefinition)sqlSessionFactoryBean);
        registry.registerBeanDefinition(scannerConfigurerName, (BeanDefinition)scannerConfigurer);
        if (primary) {
            registry.registerAlias(dataSourceName, "dataSource");
            registry.registerAlias(jdbcTemplateName, "jdbcTemplate");
            registry.registerAlias(transactionManagerName, "transactionManager");
        }
    }

    @Bean
    public DataSourceAspect dataSourceAspect() {
        return new DataSourceAspect();
    }

    @Bean
    public DataSourceInvalidRetry dataSourceInvalidRetry() {
        return new DataSourceInvalidRetry();
    }
}

