/*
 * Decompiled with CFR 0.152.
 */
package com.reger.datasource.config;

import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.reger.datasource.properties.DruidStatProperties;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DruidStatProperties.class})
@ConditionalOnClass(name={"javax.servlet.http.HttpServlet"})
@ConditionalOnProperty(name={"spring.druid.stat.enable"}, havingValue="true")
public class DruidWebStatAutoConfiguration {
    Map<String, String> druidStatParameters(DruidStatProperties druidStatConfig) {
        HashMap<String, String> druidStatParameters = new HashMap<String, String>();
        druidStatParameters.put("allow", druidStatConfig.getAllow());
        druidStatParameters.put("deny", druidStatConfig.getDeny());
        druidStatParameters.put("resetEnable", "" + druidStatConfig.getResetEnable());
        druidStatParameters.put("exclusions", druidStatConfig.getExclusions());
        druidStatParameters.put("loginUsername", druidStatConfig.getLoginUsername());
        druidStatParameters.put("loginPassword", druidStatConfig.getLoginPassword());
        return druidStatParameters;
    }

    @Bean
    ServletRegistrationBean servletRegistration(DruidStatProperties druidStatConfig) {
        ServletRegistrationBean filterRegistration = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[0]);
        filterRegistration.setAsyncSupported(true);
        filterRegistration.setEnabled(true);
        filterRegistration.addUrlMappings(new String[]{"/druid/*"});
        filterRegistration.setInitParameters(this.druidStatParameters(druidStatConfig));
        return filterRegistration;
    }

    @Bean
    FilterRegistrationBean filterRegistration(DruidStatProperties druidStatConfig) {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistration.setAsyncSupported(true);
        filterRegistration.setEnabled(true);
        filterRegistration.addUrlPatterns(new String[]{druidStatConfig.getFilterUrlPatterns()});
        filterRegistration.setInitParameters(this.druidStatParameters(druidStatConfig));
        return filterRegistration;
    }
}

