/*
 * Decompiled with CFR 0.152.
 */
package com.reger.datasource.core;

import com.github.pagehelper.PageInterceptor;
import com.reger.datasource.core.Dialect;
import com.reger.datasource.core.DynamicDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class CustomPageInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(CustomPageInterceptor.class);
    private static final Map<Dialect, PageInterceptor> pageHelpers = new HashMap<Dialect, PageInterceptor>();
    private final Interceptor pageHelper;
    private final Dialect dialect;

    public CustomPageInterceptor(Dialect dialect) {
        this.dialect = dialect;
        this.pageHelper = (Interceptor)pageHelpers.get((Object)dialect);
        Properties properties = new Properties();
        if (dialect != Dialect.other) {
            properties.setProperty("helperDialect", dialect.name());
        }
        this.pageHelper.setProperties(properties);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object object = invocation.getArgs()[0];
        if (object instanceof MappedStatement) {
            MappedStatement statement = (MappedStatement)object;
            Configuration config = statement.getConfiguration();
            DataSource dataSource = config.getEnvironment().getDataSource();
            if (dataSource instanceof DynamicDataSource) {
                DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)dataSource);
                Dialect dialect = dynamicDataSource.getDialect();
                if (pageHelpers.containsKey((Object)dialect)) {
                    log.debug("\u5c06\u4f7f\u7528{}\u7684PageHelper....", (Object)dialect);
                    return pageHelpers.get((Object)dialect).intercept(invocation);
                }
                log.debug("\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7684PageHelper,dialect=({})\u7684....", (Object)this.dialect);
            } else {
                log.debug("\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7684PageHelper,dialect=({})\u7684....", (Object)this.dialect);
            }
        } else {
            log.debug("\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7684PageHelper,dialect=({})\u7684....", (Object)this.dialect);
        }
        return this.pageHelper.intercept(invocation);
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.pageHelper.setProperties(properties);
    }

    static {
        pageHelpers.put(Dialect.H2, new PageInterceptor());
        pageHelpers.put(Dialect.DB2, new PageInterceptor());
        pageHelpers.put(Dialect.Derby, new PageInterceptor());
        pageHelpers.put(Dialect.Mysql, new PageInterceptor());
        pageHelpers.put(Dialect.SQLite, new PageInterceptor());
        pageHelpers.put(Dialect.Oracle, new PageInterceptor());
        pageHelpers.put(Dialect.Hsqldb, new PageInterceptor());
        pageHelpers.put(Dialect.Phoenix, new PageInterceptor());
        pageHelpers.put(Dialect.MariaDB, new PageInterceptor());
        pageHelpers.put(Dialect.Informix, new PageInterceptor());
        pageHelpers.put(Dialect.SqlServer, new PageInterceptor());
        pageHelpers.put(Dialect.PostgreSQL, new PageInterceptor());
        pageHelpers.put(Dialect.SqlServer2012, new PageInterceptor());
        pageHelpers.put(Dialect.other, new PageInterceptor());
        for (Map.Entry<Dialect, PageInterceptor> entry : pageHelpers.entrySet()) {
            Properties properties = new Properties();
            if (entry.getKey() != Dialect.other) {
                properties.setProperty("helperDialect", entry.getKey().name());
            }
            entry.getValue().setProperties(properties);
        }
    }
}

