/*
 * Decompiled with CFR 0.152.
 */
package com.reger.datasource.core;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.JdbcUtils;
import com.reger.datasource.core.Dialect;
import com.reger.datasource.properties.DruidProperties;
import com.reger.datasource.properties.MybatisNodeProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.scheduling.annotation.Async;

public class DynamicDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSource.class);
    private final Dialect dialect;
    private volatile int selectnum = 0;
    private final String dataSourceName;
    private final DruidDataSource masterDataSource;
    private final Map<String, DruidDataSource> slaveDataSources = new ConcurrentHashMap<String, DruidDataSource>();
    private final List<String> slavesDataSourceNames = Collections.synchronizedList(new ArrayList());
    private final List<String> slavesFailureDataSourceNames = Collections.synchronizedList(new ArrayList());
    private static final ThreadLocal<Stack<Boolean>> ismaster = new ThreadLocal<Stack<Boolean>>(){

        @Override
        protected Stack<Boolean> initialValue() {
            return new Stack<Boolean>();
        }
    };

    protected static void useMaster() {
        ismaster.get().push(true);
    }

    protected static void useSlave() {
        ismaster.get().push(false);
    }

    protected static void reset() {
        ismaster.get().pop();
        if (ismaster.get().size() == 0) {
            ismaster.remove();
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.determineTargetDataSourceConnection();
        }
        catch (SQLException e) {
            logger.info("\u83b7\u53d6jdbc\u94fe\u63a5\u5931\u8d25,\u91cd\u8bd5\u5f00\u59cb");
            return this.determineTargetDataSourceConnection();
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        try {
            return this.determineTargetDataSourceConnection(username, password);
        }
        catch (SQLException e) {
            logger.info("\u83b7\u53d6jdbc\u94fe\u63a5\u5931\u8d25,\u91cd\u8bd5\u5f00\u59cb");
            return this.determineTargetDataSourceConnection(username, password);
        }
    }

    private Connection determineTargetDataSourceConnection() throws SQLException {
        String lookupKey = this.determineCurrentLookupKey();
        DataSource datasource = this.determineTargetDataSource(lookupKey);
        try {
            return datasource.getConnection();
        }
        catch (SQLException e) {
            this.recordFailure(datasource, lookupKey, e);
            throw e;
        }
    }

    private Connection determineTargetDataSourceConnection(String username, String password) throws SQLException {
        String lookupKey = this.determineCurrentLookupKey();
        DataSource datasource = this.determineTargetDataSource(lookupKey);
        try {
            return datasource.getConnection(username, password);
        }
        catch (SQLException e) {
            this.recordFailure(datasource, lookupKey, e);
            throw e;
        }
    }

    private void recordFailure(DataSource datasource, String lookupKey, SQLException e) {
        if (this.masterDataSource.equals(datasource)) {
            logger.error("\u6570\u636e\u5e93\u4e3b\u5e93\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4e3b\u5e93\u72b6\u6001\u3002\u3002\u3002\u5f02\u5e38\u4fe1\u606f:{} {}  {}", new Object[]{e.getMessage(), e.getSQLState(), e.getErrorCode()});
            return;
        }
        this.slavesDataSourceNames.remove(lookupKey);
        this.slavesFailureDataSourceNames.add(lookupKey);
        logger.warn("\u6570\u636e\u5e93\u4ece\u5e93{}\u51fa\u73b0\u5f02\u5e38\uff0c\u5df2\u4e0b\u7ebf\u3002\u3002\u3002\u5f02\u5e38\u4fe1\u606f:{} {}  {}", new Object[]{lookupKey, e.getMessage(), e.getSQLState(), e.getErrorCode()});
    }

    @Async
    public void retryFailureSlavesDataSource() {
        if (this.slavesFailureDataSourceNames.isEmpty()) {
            return;
        }
        for (String lookupKey : this.slavesFailureDataSourceNames) {
            try {
                this.determineTargetDataSource(lookupKey).getConnection();
                this.slavesFailureDataSourceNames.remove(lookupKey);
                this.slavesDataSourceNames.add(lookupKey);
                logger.info("\u6570\u636e\u5e93\u4ece\u5e93{}\u4ece\u5f02\u5e38\u4e2d\u6062\u590d\u8fc7\u6765", (Object)lookupKey);
            }
            catch (SQLException e) {
                logger.debug("\u6d4b\u8bd5\u94fe\u63a5\u5931\u6548\u7684\u4ece\u5e93{}\u8fd8\u6ca1\u6709\u6d3b\u8fc7\u6765", (Object)lookupKey, (Object)e);
            }
        }
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        String lookupKey = this.determineCurrentLookupKey();
        return this.determineTargetDataSource(lookupKey).unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String lookupKey = this.determineCurrentLookupKey();
        return iface.isInstance((Object)this) || this.determineTargetDataSource(lookupKey).isWrapperFor(iface);
    }

    protected DataSource determineTargetDataSource(String lookupKey) {
        if (lookupKey == null) {
            return this.masterDataSource;
        }
        DataSource dataSource = (DataSource)this.slaveDataSources.get(lookupKey);
        if (dataSource != null) {
            return dataSource;
        }
        return this.masterDataSource;
    }

    protected String determineCurrentLookupKey() {
        if (ismaster.get().isEmpty() || ismaster.get().peek().booleanValue()) {
            return null;
        }
        if (!this.slavesDataSourceNames.isEmpty()) {
            int slaveCount = this.slavesDataSourceNames.size();
            String slavesDataSourceName = this.slavesDataSourceNames.get(this.selectnum % slaveCount);
            ++this.selectnum;
            this.selectnum %= slaveCount;
            logger.debug("\u5207\u6362\u5230\u4ece\u5e93{}\u4e2d\u67e5\u8be2", (Object)slavesDataSourceName);
            return slavesDataSourceName;
        }
        logger.info("{}\u7684\u4ece\u5e93\u4e0d\u53ef\u7528\uff0c\u5c06\u4f7f\u7528\u4e3b\u5e93\u67e5\u8be2", (Object)this.dataSourceName);
        return null;
    }

    public static DynamicDataSource create(MybatisNodeProperties druidNode, DruidProperties defaultDruidProperties, String dataSourceName) throws SQLException {
        return new DynamicDataSource(druidNode, defaultDruidProperties, dataSourceName);
    }

    public DynamicDataSource(MybatisNodeProperties druidNode, DruidProperties defaultDruidProperties, String dataSourceName) throws SQLException {
        this.dataSourceName = dataSourceName;
        DruidProperties master = druidNode.getMaster();
        if (master == null) {
            master = new DruidProperties();
        }
        master.merge(defaultDruidProperties).defaultEmpty().setDefaultReadOnly(false);
        this.masterDataSource = master.createDataSource();
        this.masterDataSource.setName(dataSourceName + "-Master");
        List<DruidProperties> slaves = druidNode.getSlaves();
        if (slaves != null && !slaves.isEmpty()) {
            for (int i = 0; i < slaves.size(); ++i) {
                DruidProperties slave = slaves.get(i);
                if (slave == null) continue;
                slave.merge(defaultDruidProperties).defaultEmpty().setDefaultReadOnly(true);
                String slaveDatasourceName = dataSourceName + "-Slave-" + i;
                this.slavesDataSourceNames.add(slaveDatasourceName);
                DruidDataSource datasourc = slave.createDataSource();
                datasourc.setName(slaveDatasourceName);
                this.slaveDataSources.put(slaveDatasourceName, datasourc);
            }
        }
        String rawUrl = master.getUrl();
        String dbType = JdbcUtils.getDbType((String)rawUrl, null);
        this.dialect = Dialect.valoueOfName(dbType);
    }

    public void init() throws SQLException {
        logger.debug("\u521d\u59cb\u5316 DynamicDataSource {}...", (Object)this.dataSourceName);
        this.masterDataSource.init();
        for (DruidDataSource druidDataSource : this.slaveDataSources.values()) {
            try {
                druidDataSource.init();
            }
            catch (SQLException e) {
                logger.warn("\u4ece\u5e93{}\u521d\u59cb\u5316\u5931\u8d25", (Object)druidDataSource.getName());
            }
        }
    }

    public void close() {
        logger.debug("\u9500\u6bc1 DynamicDataSource {}...", (Object)this.dataSourceName);
        this.masterDataSource.close();
        for (DruidDataSource druidDataSource : this.slaveDataSources.values()) {
            try {
                druidDataSource.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u4ece\u5e93{}\u5931\u8d25", (Object)druidDataSource.getName());
            }
        }
    }

    public DruidDataSource masterDataSource() {
        return this.masterDataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

