/*
 * Decompiled with CFR 0.152.
 */
package com.reger.datasource.core;

import com.reger.datasource.annotation.EnumTypeHandler;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalEnumTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private final Logger logger = LoggerFactory.getLogger((String)"mybatis.EnumTypeHandler");
    private final Class<E> type;
    private static final Set<String> defSET = new HashSet<String>(Arrays.asList("name", "ordinal"));
    private static final String defNull = "DEF.FIELD.NULL.ENUM";
    private final Map<E, Object> mapEnum = new ConcurrentHashMap<E, Object>();
    private final Map<Object, E> enumMap = new ConcurrentHashMap<Object, E>();
    private final Map<String, E> strEnumMap = new ConcurrentHashMap<String, E>();
    private final Map<String, E> nameEnumMap = new ConcurrentHashMap<String, E>();

    public GlobalEnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
        Field field = this.getEnumTypeHandlerField();
        if (field != null) {
            this.initMapEnum(field);
        } else {
            this.initMapEnum();
        }
    }

    private void initMapEnum() {
        for (Enum _enum : (Enum[])this.type.getEnumConstants()) {
            this.mapEnum.put(_enum, _enum.name());
            this.nameEnumMap.put(_enum.name(), _enum);
        }
    }

    private void initMapEnum(Field field) {
        boolean isAccessible = field.isAccessible();
        if (!isAccessible) {
            field.setAccessible(true);
        }
        for (Enum _enum : (Enum[])this.type.getEnumConstants()) {
            Object object = this.getField(field, _enum);
            if (object == null) {
                object = defNull;
            }
            this.logger.debug("mybatis\u5c06\u628a\u679a\u4e3e{}.{}\u8f6c\u5316\u4e3a{}\u5b58\u50a8", new Object[]{this.type.getName(), _enum, object});
            this.mapEnum.put(_enum, object);
            if (this.enumMap.containsKey(object)) {
                this.logger.warn("\u8bf7\u68c0\u67e5\u679a\u4e3e\u7c7b{},\u679a\u4e3e\u9879{}\u548c\u679a\u4e3e\u9879{}\u5b9a\u4e49\u4e86\u5b8c\u5168\u4e00\u6837\u7684\u6807\u8bc6{}", new Object[]{this.type.getName(), _enum, this.enumMap.get(object), object});
            }
            this.enumMap.put(object, _enum);
            this.strEnumMap.put(String.valueOf(object), _enum);
            this.nameEnumMap.put(_enum.name(), _enum);
        }
        if (!isAccessible) {
            field.setAccessible(isAccessible);
        }
    }

    private Field getEnumTypeHandlerField() {
        EnumTypeHandler handler = this.type.getAnnotation(EnumTypeHandler.class);
        if (handler == null) {
            return null;
        }
        Field field = null;
        String fieldName = handler.field();
        try {
            field = this.type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            field = this.outException(fieldName, e);
        }
        catch (SecurityException e) {
            field = this.outException(fieldName, e);
        }
        return field;
    }

    private Field outException(String fieldName, Exception e) {
        block4: {
            if (defSET.contains(fieldName)) {
                try {
                    return Enum.class.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e1) {
                    this.logger.warn("\u52a0\u8f7d\u679a\u4e3e{}\u4fe1\u606f\u5931\u8d25", (Object)this.type.getName(), (Object)e);
                    break block4;
                }
                catch (SecurityException e1) {
                    this.logger.warn("\u52a0\u8f7d\u679a\u4e3e{}\u4fe1\u606f\u5931\u8d25", (Object)this.type.getName(), (Object)e);
                    break block4;
                }
            }
            this.logger.warn("\u52a0\u8f7d\u679a\u4e3e{}\u4fe1\u606f\u5931\u8d25", (Object)this.type.getName(), (Object)e);
        }
        return null;
    }

    private E findObject(Object object) {
        if (object == null) {
            return (E)((Enum)this.enumMap.get(defNull));
        }
        if (this.enumMap.containsKey(object)) {
            return (E)((Enum)this.enumMap.get(object));
        }
        String objectStr = String.valueOf(object);
        if (this.nameEnumMap.containsKey(objectStr)) {
            return (E)((Enum)this.nameEnumMap.get(objectStr));
        }
        if (this.strEnumMap.containsKey(objectStr)) {
            return (E)((Enum)this.strEnumMap.get(objectStr));
        }
        this.logger.error("\u6570\u636e{}\u8f6c\u5316\u4e3a\u679a\u4e3e{}\u65f6\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u679a\u4e3e", object, (Object)this.type.getName());
        return null;
    }

    private Object getField(Field field, E _enum) {
        try {
            return field.get(_enum);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("\u53d6\u679a\u4e3e{}.{}\u7684field:{}\u5931\u8d25", new Object[]{this.type.getName(), _enum, field.getName(), e});
        }
        catch (IllegalAccessException e) {
            this.logger.warn("\u53d6\u679a\u4e3e{}.{}\u7684field:{}\u5931\u8d25", new Object[]{this.type.getName(), _enum, field.getName(), e});
        }
        return ((Enum)_enum).name();
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        if (jdbcType == null) {
            ps.setObject(i, this.mapEnum.get(parameter));
        } else {
            ps.setObject(i, this.mapEnum.get(parameter), jdbcType.TYPE_CODE);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object s = rs.getObject(columnName);
        return this.findObject(s);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object s = rs.getObject(columnIndex);
        return this.findObject(s);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object s = cs.getObject(columnIndex);
        return this.findObject(s);
    }
}

