/*
 * Decompiled with CFR 0.152.
 */
package com.reger.datasource.core;

import com.reger.datasource.core.DynamicDataSource;

public abstract class Proxy {
    public static <T> T slave(SwitchExecute<T> runnable) {
        DynamicDataSource.useSlave();
        return Proxy.execute(runnable);
    }

    public static <T> T master(SwitchExecute<T> runnable) {
        DynamicDataSource.useMaster();
        return Proxy.execute(runnable);
    }

    private static <T> T execute(SwitchExecute<T> runnable) {
        try {
            T t = runnable.run();
            return t;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            DynamicDataSource.reset();
        }
    }

    public static interface SwitchExecute<T> {
        public T run() throws Throwable;
    }
}

