/*
 * Decompiled with CFR 0.152.
 */
package com.reger.mybatis.base.controller;

import com.github.pagehelper.PageInfo;
import com.reger.core.model.ResponseEntity;
import com.reger.mybatis.base.service.Service;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class Controller<OpsUser, T, TI extends T, TU extends T, TO extends T, TS extends T, ID> {
    @Autowired(required=false)
    protected Service<OpsUser, T, TI, TU, TO, TS, ID> service;

    protected abstract OpsUser getOpsUser();

    protected void init(T t) {
    }

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58")
    public ResponseEntity<TO> save(@RequestBody TI ti) {
        Assert.notNull(this.service, (String)"\u6ca1\u6709\u6b63\u786e\u6ce8\u5165service\u5c42");
        OpsUser opsUser = this.getOpsUser();
        this.init(ti);
        TO entity = this.service.save(ti, opsUser);
        return ResponseEntity.success(entity);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6309\u4e3b\u952e\u83b7\u53d6\u4e00\u4e2a")
    public ResponseEntity<TO> get(@PathVariable ID id) {
        Assert.notNull(this.service, (String)"\u6ca1\u6709\u6b63\u786e\u6ce8\u5165service\u5c42");
        OpsUser opsUser = this.getOpsUser();
        TO entity = this.service.get(id, opsUser);
        return ResponseEntity.success(entity);
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u6309\u4e3b\u952e\u66f4\u65b0\u4e00\u4e2a")
    public ResponseEntity<TO> update(@PathVariable ID id, @RequestBody TU ti) {
        Assert.notNull(this.service, (String)"\u6ca1\u6709\u6b63\u786e\u6ce8\u5165service\u5c42");
        OpsUser opsUser = this.getOpsUser();
        this.init(ti);
        TO entity = this.service.update(id, ti, opsUser);
        return ResponseEntity.success(entity);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6309\u4e3b\u952e\u5220\u9664\u4e00\u4e2a")
    public ResponseEntity<?> del(@PathVariable ID id) {
        Assert.notNull(this.service, (String)"\u6ca1\u6709\u6b63\u786e\u6ce8\u5165service\u5c42");
        OpsUser opsUser = this.getOpsUser();
        this.service.del(id, opsUser);
        return ResponseEntity.success();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5206\u9875\u5217\u51fa")
    public ResponseEntity<PageInfo<TO>> list(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize) {
        Assert.notNull(this.service, (String)"\u6ca1\u6709\u6b63\u786e\u6ce8\u5165service\u5c42");
        OpsUser opsUser = this.getOpsUser();
        PageInfo<TO> entity = this.service.list(pageNo, pageSize, opsUser);
        return ResponseEntity.success(entity);
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5e26\u6761\u4ef6\u67e5\u8be2,\u5206\u9875\u5217\u51fa")
    public ResponseEntity<PageInfo<TO>> search(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody TS search) {
        Assert.notNull(this.service, (String)"\u6ca1\u6709\u6b63\u786e\u6ce8\u5165service\u5c42");
        OpsUser opsUser = this.getOpsUser();
        this.init(search);
        PageInfo<TO> entity = this.service.search(pageNo, pageSize, search, opsUser);
        return ResponseEntity.success(entity);
    }
}

