/*
 * Decompiled with CFR 0.152.
 */
package com.reger.mybatis.generator;

import com.alibaba.druid.util.JdbcUtils;
import com.reger.datasource.core.Dialect;
import com.reger.datasource.core.Mapper;
import com.reger.datasource.properties.DaoProperties;
import com.reger.datasource.properties.DruidProperties;
import com.reger.datasource.properties.MybatisNodeProperties;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.api.VerboseProgressCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@SpringBootConfiguration
public class GeneratorMain
implements CommandLineRunner,
EnvironmentAware {
    ConfigurableEnvironment environment;

    public static void main(String[] args) throws Exception {
        SpringApplication.run(GeneratorMain.class, (String[])args);
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    private <T> T getDruidConfig(String prefix, Class<T> claz) {
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(claz);
        factory.setPropertySources((PropertySources)this.environment.getPropertySources());
        factory.setConversionService((ConversionService)this.environment.getConversionService());
        factory.setIgnoreInvalidFields(false);
        factory.setIgnoreUnknownFields(true);
        factory.setIgnoreNestedProperties(false);
        factory.setTargetName(prefix);
        try {
            factory.bindPropertiesToTarget();
            return (T)factory.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MybatisNodeProperties getNodeBYName(String name) {
        DaoProperties daoProperties = this.getDruidConfig("spring.mybatis", DaoProperties.class);
        DruidProperties druidProperties = this.getDruidConfig("spring.druid.default", DruidProperties.class);
        Map<String, MybatisNodeProperties> nodes = daoProperties.getNodes();
        Assert.isTrue((boolean)nodes.containsKey(name), (String)("\u8282\u70b9" + name + "\u4e0d\u5b58\u5728"));
        MybatisNodeProperties node = nodes.get(name);
        DruidProperties master = node.getMaster();
        if (master == null) {
            master = new DruidProperties();
            node.setMaster(master);
        }
        master.merge(druidProperties);
        return node;
    }

    public void run(String ... args) throws Exception {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource("generator.properties"));
        String nodeName = properties.getProperty("mybatis.nodeName", null);
        Assert.hasText((String)nodeName, (String)"\u8282\u70b9\u540d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        MybatisNodeProperties node = this.getNodeBYName(nodeName);
        this.buildProperties(properties, node);
        Assert.hasText((String)properties.getProperty("package.model"), (String)"mapper\u7684model\u76ee\u5f55\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff0c\u914d\u7f6e\u9879 package.model");
        Assert.hasText((String)properties.getProperty("package.repo"), (String)"mapper\u7684\u63a5\u53e3\u76ee\u5f55\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff0c\u914d\u7f6e\u9879 package.repo");
        Assert.hasText((String)properties.getProperty("package.mapper"), (String)"mapper\u7684xml\u76ee\u5f55\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff0c\u914d\u7f6e\u9879 package.mapper");
        this.generate(properties);
    }

    private void buildProperties(Properties properties, MybatisNodeProperties node) throws SQLException {
        Mapper mapper;
        DruidProperties master = node.getMaster().defaultEmpty();
        String driverClassName = JdbcUtils.getDriverClassName((String)master.getUrl());
        String dbtype = JdbcUtils.getDbType((String)master.getUrl(), (String)driverClassName);
        Dialect dialect = node.getDialect();
        if (null == dialect) {
            dialect = Dialect.valoueOfName(dbtype);
        }
        if ((mapper = node.getMapper()) == null) {
            mapper = Mapper.valueOfDialect(dialect);
        }
        properties.setProperty("jdbc.url", master.getUrl());
        properties.setProperty("jdbc.username", master.getUsername());
        properties.setProperty("jdbc.password", master.getPassword());
        properties.setProperty("jdbc.driverClassName", driverClassName);
        properties.setProperty("jdbc.type", dbtype);
        properties.setProperty("extends.Mapper", mapper.toString());
        if (!StringUtils.hasText((String)properties.getProperty("extends.modelClass"))) {
            properties.setProperty("extends.modelClass", Object.class.getName());
        }
        if (!StringUtils.hasText((String)properties.getProperty("java.delimiter"))) {
            properties.setProperty("java.delimiter", "");
        }
        if (!StringUtils.hasText((String)properties.getProperty("java.encoding"))) {
            properties.setProperty("java.encoding", "UTF-8");
        }
        if (!StringUtils.hasText((String)properties.getProperty("package.model"))) {
            properties.setProperty("package.model", this.getFirstPackage(node.getTypeAliasesPackage()));
        }
        if (!StringUtils.hasText((String)properties.getProperty("package.repo"))) {
            properties.setProperty("package.repo", this.getFirstPackage(node.getBasePackage()));
        }
        if (!StringUtils.hasText((String)properties.getProperty("package.mapper"))) {
            String alias = this.getFirstPackage(node.getMapperPackage());
            alias = StringUtils.hasText((String)alias) ? ClassUtils.convertClassNameToResourcePath((String)alias) : "";
            properties.setProperty("package.mapper", alias);
        }
    }

    private String getFirstPackage(String packageStrs) {
        String[] packages;
        if (!StringUtils.hasText((String)packageStrs)) {
            return "";
        }
        for (String packageStr : packages = packageStrs.split(",")) {
            if ((packageStr = packageStr.trim()).indexOf("*") != -1) continue;
            return packageStr;
        }
        return "";
    }

    private void generate(Properties properties) throws IOException, XMLParserException, SQLException, InterruptedException, InvalidConfigurationException {
        ClassPathResource resource = new ClassPathResource("META-INF/generator/generatorconfig.xml");
        ArrayList warnings = new ArrayList();
        ConfigurationParser cp = new ConfigurationParser(properties, warnings);
        Configuration config = cp.parseConfiguration(resource.getInputStream());
        System.err.println("#############################################################################################");
        System.err.println("######################################\u5f00\u59cb\u751f\u6210##################################################");
        System.err.println("#############################################################################################");
        new MyBatisGenerator(config, (ShellCallback)new DefaultShellCallback(true), warnings).generate((ProgressCallback)new VerboseProgressCallback());
        System.err.println("#############################################################################################");
        System.err.println("#######################################\u751f\u6210\u5b8c\u6bd5#################################################");
        System.err.println("#############################################################################################");
    }
}

