package org.sean.framework.config;

import org.elasticsearch.client.RestHighLevelClient;
import org.sean.framework.es.CommonOperation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * ES Configuration
 */
@Configuration
public class ElasticAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public CommonOperation commonOperation(RestHighLevelClient client) {
        return new CommonOperation(client);
    }

}
