/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.ioc.factory;

import com.yuyenews.aop.proxy.CglibProxy;
import com.yuyenews.core.annotation.EasyAop;
import com.yuyenews.core.annotation.EasyAopType;
import com.yuyenews.core.annotation.Traction;
import com.yuyenews.core.constant.EasySpace;
import com.yuyenews.core.model.EasyBeanModel;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanFactory {
    private static Logger log = LoggerFactory.getLogger(BeanFactory.class);

    public static Object createBean(Class<?> className) {
        try {
            HashMap list = new HashMap();
            BeanFactory.getAopClass(className, list);
            if (list != null && list.size() > 0) {
                CglibProxy cglibProxy = new CglibProxy();
                return cglibProxy.getProxy(className, list);
            }
            return className.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa[" + className.getName() + "]\u7c7b\u578b\u7684bean\u5bf9\u8c61\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private static void getAopClass(Class<?> className, Map<String, Class<?>> list) throws Exception {
        Method[] methods;
        EasyAopType allEasyAop = className.getAnnotation(EasyAopType.class);
        for (Method method : methods = className.getMethods()) {
            EasyAop easyAop = method.getAnnotation(EasyAop.class);
            Traction traction = method.getAnnotation(Traction.class);
            if (easyAop != null && traction != null) {
                log.error(className.getName() + "\u7c7b\u4e2d\u7684[" + method.getName() + "]\u65b9\u6cd5\u540c\u65f6\u5b58\u5728EasyAop\u548cTraction\u6ce8\u89e3");
                throw new Exception(className.getName() + "\u7c7b\u4e2d\u7684[" + method.getName() + "]\u65b9\u6cd5\u540c\u65f6\u5b58\u5728EasyAop\u548cTraction\u6ce8\u89e3");
            }
            if (allEasyAop != null) {
                list.put(method.getName(), allEasyAop.className());
            }
            if (easyAop != null) {
                list.put(method.getName(), easyAop.className());
                continue;
            }
            if (traction == null) continue;
            Class<?> aopClass = Class.forName("com.yuyenews.easy.traction.TractionAop");
            list.put(method.getName(), aopClass);
        }
    }

    public static Object getBean(String name) {
        try {
            EasySpace constants = EasySpace.getEasySpace();
            Object objs2 = constants.getAttr("easyBeanObjs");
            Map easyBeanObjs = new HashMap();
            if (objs2 != null) {
                easyBeanObjs = (Map)objs2;
            }
            return ((EasyBeanModel)easyBeanObjs.get(name)).getObj();
        }
        catch (Exception e) {
            log.error("\u627e\u4e0d\u5230name\u4e3a[" + name + "]\u7684bean", (Throwable)e);
            return null;
        }
    }
}

