/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.ioc.load;

import com.yuyenews.core.annotation.EasyBean;
import com.yuyenews.core.annotation.Resource;
import com.yuyenews.core.constant.EasySpace;
import com.yuyenews.core.model.EasyBeanModel;
import com.yuyenews.core.util.StringUtil;
import com.yuyenews.ioc.factory.BeanFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadEasyBean {
    private static Logger log = LoggerFactory.getLogger(LoadEasyBean.class);
    private static EasySpace constants = EasySpace.getEasySpace();

    public static void loadBean() {
        try {
            Object objs = constants.getAttr("easyBeans");
            List contorls = null;
            if (objs == null) {
                return;
            }
            contorls = (List)objs;
            Object objs2 = constants.getAttr("easyBeanObjs");
            HashMap<String, EasyBeanModel> easyBeanObjs = new HashMap();
            if (objs2 != null) {
                easyBeanObjs = (Map)objs2;
            }
            for (Map map : contorls) {
                Class cls = (Class)map.get("className");
                EasyBean easyBean = (EasyBean)map.get("annotation");
                String beanName = easyBean.name();
                if (beanName == null || beanName.equals("")) {
                    beanName = StringUtil.getFirstLowerCase((String)cls.getSimpleName());
                }
                if (easyBeanObjs.get(beanName) == null) {
                    EasyBeanModel beanModel = new EasyBeanModel();
                    beanModel.setName(beanName);
                    beanModel.setCls(cls);
                    beanModel.setObj(BeanFactory.createBean(cls));
                    easyBeanObjs.put(beanName, beanModel);
                    continue;
                }
                throw new Exception("\u5df2\u7ecf\u5b58\u5728name\u4e3a[" + beanName + "]\u7684bean\u4e86");
            }
            LoadEasyBean.iocBean(easyBeanObjs);
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u5e76\u6ce8\u5165EasyBean\u7684\u65f6\u5019\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
    }

    private static void iocBean(Map<String, EasyBeanModel> easyBeanObjs) {
        try {
            for (String key : easyBeanObjs.keySet()) {
                Field[] fields;
                EasyBeanModel easyBeanModel = easyBeanObjs.get(key);
                Object obj = easyBeanModel.getObj();
                Class cls = easyBeanModel.getCls();
                for (Field f : fields = cls.getDeclaredFields()) {
                    EasyBeanModel beanModel;
                    Resource resource = f.getAnnotation(Resource.class);
                    if (resource == null) continue;
                    f.setAccessible(true);
                    String filedName = resource.name();
                    if (filedName == null || filedName.equals("")) {
                        filedName = f.getName();
                    }
                    if ((beanModel = easyBeanObjs.get(filedName)) != null) {
                        f.set(obj, beanModel.getObj());
                        log.info(cls.getName() + "\u7684\u5c5e\u6027" + f.getName() + "\u6ce8\u5165\u6210\u529f");
                        continue;
                    }
                    throw new Exception("\u4e0d\u5b58\u5728name\u4e3a" + filedName + "\u7684easyBean");
                }
                easyBeanModel.setCls(cls);
                easyBeanObjs.put(key, easyBeanModel);
            }
            constants.setAttr("easyBeanObjs", easyBeanObjs);
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u5e76\u6ce8\u5165EasyBean\u7684\u65f6\u5019\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
    }
}

