/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.easy.netty.thread;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yuyenews.core.util.ConfigUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static BlockingQueue<Runnable> workQueue;
    private static ThreadPoolExecutor pool;
    private static int corePoolSize;
    private static int maximumPoolSize;
    private static int keepAliveTime;

    public static void execute(Runnable command) {
        if (pool == null) {
            ThreadPool.init();
            workQueue = new ArrayBlockingQueue<Runnable>(maximumPoolSize - corePoolSize);
            pool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue);
        }
        pool.execute(command);
    }

    private static void init() {
        JSONObject jsonObject = ConfigUtil.getConfig();
        Object obj = jsonObject.get((Object)"threadPool");
        if (obj != null) {
            JSONObject threadPool = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
            Object cs = threadPool.get((Object)"corePoolSize");
            Object mp = threadPool.get((Object)"maximumPoolSize");
            Object kt = threadPool.get((Object)"keepAliveTime");
            if (cs != null) {
                corePoolSize = Integer.parseInt(cs.toString());
            }
            if (mp != null) {
                maximumPoolSize = Integer.parseInt(mp.toString());
            }
            if (kt != null) {
                keepAliveTime = Integer.parseInt(kt.toString());
            }
        }
    }

    static {
        corePoolSize = 100;
        maximumPoolSize = 1000;
        keepAliveTime = 60;
    }
}

