/*
 * Decompiled with CFR 0.152.
 */
package com.xinjump.generator.config;

import com.google.common.collect.Maps;
import com.xinjump.base.util.lang.StringUtils;
import com.xinjump.generator.dao.GeneratorDao;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DBContext
implements InitializingBean {
    @Autowired
    private ApplicationContext applicationContext;
    private final Map<String, GeneratorDao> generatorMap = Maps.newHashMap();

    public GeneratorDao getGenerator(String type) {
        return this.generatorMap.get(type);
    }

    public void afterPropertiesSet() throws Exception {
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(Mapper.class);
        beansWithAnnotation.forEach((key, value) -> {
            String generatorDao = StringUtils.remove((String)key, (String)"GeneratorDao");
            if (StringUtils.isNotBlank((CharSequence)generatorDao)) {
                this.generatorMap.put(StringUtils.lowerCase((String)generatorDao), (GeneratorDao)value);
            }
        });
    }
}

