/*
 * Decompiled with CFR 0.152.
 */
package com.xinjump.generator.helper;

import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xinjump.generator.entity.ColumnEntity;
import com.xinjump.generator.entity.TableEntity;
import com.xinjump.generator.exception.BusinessException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class GeneratorHelper {
    public static void generatorCode(Map<String, String> table, List<Map<String, String>> columns, ZipOutputStream zip) {
        Configuration config = GeneratorHelper.getConfig();
        boolean hasBigDecimal = false;
        String tableName = table.get("tableName");
        String className = GeneratorHelper.tableToJava(tableName, config.getString("tablePrefix"));
        TableEntity tableEntity = TableEntity.builder().tableName(tableName).comments(table.get("tableComment")).className(className).classname(StringUtils.uncapitalize((String)className)).pathName(GeneratorHelper.tableToPathName(tableName, config.getString("tablePrefix"))).build();
        ArrayList columsList = Lists.newArrayList();
        for (Map<String, String> column : columns) {
            String columnName = column.get("columnName");
            String attrName = GeneratorHelper.columnToJava(columnName);
            String dataType = column.get("dataType");
            String attrType = config.getString(dataType, "unknowType");
            ColumnEntity columnEntity = ColumnEntity.builder().columnName(columnName).dataType(dataType).comments(column.get("columnComment")).attrName(attrName).attrname(StringUtils.uncapitalize((String)attrName)).attrType(attrType).extra(column.get("extra")).build();
            if (!hasBigDecimal && attrType.equals("BigDecimal")) {
                hasBigDecimal = true;
            }
            if ("PRI".equalsIgnoreCase(column.get("columnKey")) && tableEntity.getPk() == null) {
                tableEntity.setPk(columnEntity);
            }
            columsList.add(columnEntity);
        }
        tableEntity.setColumns(columsList);
        if (tableEntity.getPk() == null) {
            tableEntity.setPk(tableEntity.getColumns().get(0));
        }
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)prop);
        VelocityContext context = GeneratorHelper.getVelocity(tableEntity, config, hasBigDecimal);
        Map<String, Function<String, String>> templates = GeneratorHelper.getTemplates(config);
        templates.forEach((template, function) -> {
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
            tpl.merge((Context)context, (Writer)sw);
            try {
                zip.putNextEntry(new ZipEntry((String)function.apply(className)));
                IOUtils.write((String)sw.toString(), (OutputStream)zip, (String)"UTF-8");
                IOUtils.closeQuietly((Writer)sw);
                zip.closeEntry();
            }
            catch (IOException e) {
                throw new BusinessException("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + tableName);
            }
        });
    }

    public static VelocityContext getVelocity(TableEntity tableEntity, Configuration config, boolean hasBigDecimal) {
        HashMap map = Maps.newHashMap();
        map.put("tableName", tableEntity.getTableName());
        map.put("comments", tableEntity.getComments());
        map.put("pk", tableEntity.getPk());
        map.put("columns", tableEntity.getColumns());
        map.put("className", tableEntity.getClassName());
        map.put("classname", tableEntity.getClassname());
        map.put("pathName", tableEntity.getPathName());
        map.put("hasBigDecimal", hasBigDecimal);
        map.put("mainPath", config.getString("mainPath"));
        map.put("package", config.getString("package"));
        map.put("moduleName", config.getString("moduleName"));
        map.put("author", config.getString("author"));
        map.put("email", config.getString("email"));
        map.put("datetime", DateUtil.formatDateTime((Date)new Date()));
        map.put("version", config.getString("version"));
        map.put("createDate", config.getString("createDate"));
        map.put("updateDate", config.getString("updateDate"));
        return new VelocityContext((Map)map);
    }

    public static Configuration getConfig() {
        try {
            return new PropertiesConfiguration("generator.properties");
        }
        catch (ConfigurationException e) {
            throw new BusinessException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
        }
    }

    public static String columnToJava(String columnName) {
        return WordUtils.capitalizeFully((String)columnName, (char[])new char[]{'_'}).replace("_", "");
    }

    public static String removeTablePrefix(String tableName, String tablePrefix) {
        if (StringUtils.isNotBlank((String)tablePrefix) && tableName.startsWith(tablePrefix)) {
            tableName = tableName.replaceFirst(tablePrefix, "");
        }
        return tableName;
    }

    public static String tableToJava(String tableName, String tablePrefix) {
        return GeneratorHelper.columnToJava(GeneratorHelper.removeTablePrefix(tableName, tablePrefix));
    }

    public static String tableToPathName(String tableName, String tablePrefix) {
        return WordUtils.capitalizeFully((String)GeneratorHelper.removeTablePrefix(tableName, tablePrefix), (char[])new char[]{'_'}).replace("_", "/").toLowerCase();
    }

    private static Map<String, Function<String, String>> getTemplates(Configuration config) {
        HashMap resultMap = Maps.newHashMap();
        String packageName = config.getString("package");
        String moduleName = config.getString("moduleName");
        String packagePath = "main" + File.separator + "java" + File.separator;
        if (StringUtils.isNotBlank((String)packageName)) {
            packagePath = packagePath + packageName.replace(".", File.separator) + File.separator + moduleName + File.separator;
        }
        String finalPackagePath = packagePath;
        resultMap.put("template/Entity.java.vm", className -> finalPackagePath + "entity" + File.separator + className + "Entity.java");
        resultMap.put("template/QueryReq.java.vm", className -> finalPackagePath + "model.req" + File.separator + className + "Req.java");
        resultMap.put("template/Mapper.java.vm", className -> finalPackagePath + "mapper" + File.separator + className + "Mapper.java");
        resultMap.put("template/Mapper.xml.vm", className -> "main" + File.separator + "resources" + File.separator + "mapper" + File.separator + moduleName + File.separator + className + "Mapper.xml");
        resultMap.put("template/Service.java.vm", className -> finalPackagePath + "service" + File.separator + "I" + className + "Service.java");
        resultMap.put("template/ServiceImpl.java.vm", className -> finalPackagePath + "service" + File.separator + "impl" + File.separator + className + "ServiceImpl.java");
        resultMap.put("template/Controller.java.vm", className -> finalPackagePath + "controller" + File.separator + className + "Controller.java");
        return resultMap;
    }
}

