/*
 * Decompiled with CFR 0.152.
 */
package com.xinjump.generator.service.impl;

import cn.hutool.core.convert.Convert;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xinjump.generator.dao.GeneratorDao;
import com.xinjump.generator.helper.GeneratorHelper;
import com.xinjump.generator.service.GeneratorService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneratorServiceImpl
implements GeneratorService {
    @Autowired
    private GeneratorDao generatorDao;

    @Override
    public PageInfo queryList(Map<String, Object> params) {
        PageHelper.startPage((int)Convert.toInt((Object)params.get("page")), (int)Convert.toInt((Object)params.get("limit")));
        List<Map<String, Object>> maps = this.generatorDao.queryList(params);
        return PageInfo.of(maps);
    }

    @Override
    public byte[] generatorCode(String[] tableNames) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        for (String tableName : tableNames) {
            Map<String, String> table = this.generatorDao.queryTable(tableName);
            List<Map<String, String>> columns = this.generatorDao.queryColumns(tableName);
            GeneratorHelper.generatorCode(table, columns, zip);
        }
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }
}

