/*
 * Decompiled with CFR 0.152.
 */
package com.xq.verify;

import cn.hutool.json.JSONUtil;
import com.xq.common.ResponseBean;
import com.xq.verify.annotation.ParamValidate;
import com.xq.verify.support.AbstractFromValidatorImpl;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Aspect
public class ParamValidateAspect {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private HttpServletRequest httpServletRequest;

    @Around(value="@annotation(com.xq.verify.annotation.ParamValidate)")
    @Order(value=1)
    public Object paramValidate(ProceedingJoinPoint pjp) throws Throwable {
        Class<? extends AbstractFromValidatorImpl>[] validators;
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        ParamValidate paramValidate = method.getAnnotation(ParamValidate.class);
        for (Class<? extends AbstractFromValidatorImpl> validatorClass : validators = paramValidate.value()) {
            boolean isSatisfy;
            AbstractFromValidatorImpl fromValidatorImpl = (AbstractFromValidatorImpl)this.applicationContext.getBean(validatorClass);
            ResponseBean bp = fromValidatorImpl.check(this.httpServletRequest);
            if (null == bp) continue;
            if (ResponseBean.class.isAssignableFrom(method.getReturnType())) {
                return JSONUtil.toBean(JSONUtil.toJsonStr(bp), method.getReturnType());
            }
            boolean bl = isSatisfy = method.getDeclaringClass().isAnnotationPresent(RestController.class) || method.isAnnotationPresent(ResponseBody.class) && String.class.equals(method.getReturnType());
            if (isSatisfy) {
                return JSONUtil.toJsonStr(bp);
            }
            throw new RuntimeException("\u8868\u5355\u9a8c\u8bc1\u5931\u8d25");
        }
        return pjp.proceed();
    }
}

