/*
 * Decompiled with CFR 0.152.
 */
package com.xq.verify.support;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.xq.common.ResponseBean;
import com.xq.verify.exception.ValidateException;
import com.xq.verify.support.ParamValidator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFromValidatorImpl
extends ResponseBean
implements ParamValidator {
    private static final Logger log = LoggerFactory.getLogger(AbstractFromValidatorImpl.class);
    protected HttpServletRequest request;

    protected abstract void validate();

    @Override
    public ResponseBean check(HttpServletRequest request) {
        this.request = request;
        try {
            this.validate();
        }
        catch (ValidateException validateException) {
            ResponseBean failure = ResponseBean.failure();
            failure.setCode(this.code);
            failure.setMessage(this.message);
            return failure;
        }
        return null;
    }

    @Override
    public void addError(String code, String message) {
        this.code = code;
        this.message = message;
        throw new ValidateException();
    }

    public String getParameter(String field) {
        String fieldValue = this.request.getParameter(field);
        if (StrUtil.isBlank(fieldValue)) {
            String bodyJson = this.getBodyJson();
            if (StrUtil.isBlank(bodyJson)) {
                return fieldValue;
            }
            JSONConfig jsonConfig = new JSONConfig();
            jsonConfig.setIgnoreNullValue(true);
            Map jsonBody = JSONUtil.toBean(bodyJson, jsonConfig, Map.class);
            fieldValue = jsonBody.getOrDefault(field, "").toString();
        }
        return fieldValue;
    }

    private String getBodyJson() {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            ServletInputStream inputStream = this.request.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6body\u6570\u636e\u53d1\u751f\u9519\u8bef\uff1a{}", (Throwable)exception);
            return null;
        }
    }

    protected void validateRequired(String field, String message) {
        String value = this.getParameter(field);
        if (StrUtil.isBlank(value)) {
            this.addError("1", message);
        }
    }
}

