/*
 * Decompiled with CFR 0.152.
 */
package leisure.springboot.redis.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class LeisureRedis {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public boolean expire(String key, long time) {
        if (time > 0L) {
            this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public String get(String key) {
        return key == null ? null : (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        return true;
    }

    public boolean set(String key, String value, long time) {
        if (time > 0L) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, time, TimeUnit.SECONDS);
        } else {
            this.set(key, value);
        }
        return true;
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hGet(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmGet(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
        return true;
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public boolean hset(String key, String item, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
        return true;
    }

    public boolean hset(String key, String item, Object value, long time) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hIncr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hDecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<String> sGet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public boolean sHasKey(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public long sSet(String key, String ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public long sSetAndTime(String key, long time, String ... values) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
        if (time > 0L) {
            this.expire(key, time);
        }
        return count;
    }

    public long getSetSize(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public long removeSet(String key, Object ... values) {
        Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
        return count;
    }

    public List<String> getList(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public long getListSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public Object getIndex(String key, long index) {
        return this.redisTemplate.opsForList().index((Object)key, index);
    }

    public boolean listSet(String key, String value) {
        this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
        return true;
    }

    public boolean listSet(String key, String value, long time) {
        this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public boolean lSet(String key, List<String> value) {
        this.redisTemplate.opsForList().rightPushAll((Object)key, value);
        return true;
    }

    public boolean lSet(String key, List<String> value, long time) {
        this.redisTemplate.opsForList().rightPushAll((Object)key, value);
        if (time > 0L) {
            this.expire(key, time);
        }
        return true;
    }

    public boolean lUpdateIndex(String key, long index, String value) {
        this.redisTemplate.opsForList().set((Object)key, index, (Object)value);
        return true;
    }

    public long lRemove(String key, long count, Object value) {
        Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
        return remove;
    }
}

