/*
 * Decompiled with CFR 0.152.
 */
package com.github.alex.cloud.framework.excel.service.poi;

import com.github.alex.cloud.framework.excel.model.ExcelModel;
import com.github.alex.cloud.framework.excel.service.ExcelService;
import com.github.alex.cloud.framework.excel.util.ExcelUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class HSSFExcelServiceImpl
implements ExcelService {
    private static final Logger log = LoggerFactory.getLogger(HSSFExcelServiceImpl.class);

    @Override
    public <T> List<T> readExcel(File file, Class<T> clazz) throws IOException {
        if (file == null) {
            log.error("\u8bfb\u53d6Excel\u5931\u8d25\uff0c\u539f\u56e0\u662f\u7ed9\u5b9a\u7684excel\u6587\u4ef6\u4e3a\u7a7a");
            return null;
        }
        if (!file.exists()) {
            log.error("\u8bfb\u53d6Excel\u5931\u8d25\uff0c\u539f\u56e0\u662f\u7ed9\u5b9a\u7684excel\u6587\u4ef6\u4e0d\u5b58\u5728");
            return null;
        }
        if (file.isDirectory()) {
            log.error("\u8bfb\u53d6Excel\u5931\u8d25\uff0c\u539f\u56e0\u662f\u7ed9\u5b9a\u7684\u6587\u4ef6\u662f\u4e2a\u76ee\u5f55\u6587\u4ef6\u5939");
            return null;
        }
        if (clazz == null) {
            log.error("\u8bfb\u53d6Excel\u5931\u8d25\uff0c\u539f\u56e0\u662f\u7ed9\u5b9a\u7684\u5b9e\u4f53\u6cdb\u578b\u4e3a\u7a7a");
            return null;
        }
        LinkedList dataList = new LinkedList();
        ExcelModel excelModel = new ExcelModel();
        ExcelUtils.findSheetProperty(clazz, excelModel);
        ExcelUtils.findColmunProperty(clazz, excelModel);
        FileInputStream is = new FileInputStream(file);
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)is);
        Sheet sheet = ExcelUtils.findDataSheet((Workbook)wb, excelModel);
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            if (i >= excelModel.getTitleLength()) continue;
            Row row = sheet.getRow(i);
        }
        return dataList;
    }

    @Override
    public <T> List<T> readExcel(InputStream inputStream, Class<?> clazz) {
        return null;
    }

    @Override
    public <T> List<T> readExcel(MultipartFile multipartFile, Class<?> clazz) {
        return null;
    }
}

