/*
 * Decompiled with CFR 0.152.
 */
package com.github.alex.cloud.framework.excel.util;

import com.alibaba.fastjson.JSON;
import com.github.alex.cloud.framework.excel.annotation.ExcelColumn;
import com.github.alex.cloud.framework.excel.annotation.ExcelSheet;
import com.github.alex.cloud.framework.excel.model.ExcelModel;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    private ExcelUtils() {
    }

    public static synchronized void findSheetProperty(Class<?> clazz, ExcelModel excelModel) {
        String sheetName = "";
        Integer sheetIndex = -1;
        Integer sheetTitleLength = 1;
        boolean excelSheetAnnotation = clazz.isAnnotationPresent(ExcelSheet.class);
        if (excelSheetAnnotation) {
            ExcelSheet excelSheet = clazz.getAnnotation(ExcelSheet.class);
            sheetName = excelSheet.name();
            sheetIndex = excelSheet.index();
            sheetTitleLength = excelSheet.titleLength();
            if (sheetIndex != null && sheetIndex > -1) {
                sheetName = null;
            } else {
                sheetIndex = StringUtils.isEmpty((Object)sheetName) ? Integer.valueOf(0) : null;
            }
        } else {
            sheetIndex = 0;
        }
        excelModel.setSheetName(sheetName);
        excelModel.setSheetIndex(sheetIndex);
        excelModel.setTitleLength(sheetTitleLength);
    }

    public static synchronized void findColmunProperty(Class<?> clazz, ExcelModel excelModel) {
        Field[] fields;
        LinkedHashMap<String, String> modelColumnTitleMap = new LinkedHashMap<String, String>();
        LinkedHashMap<Integer, String> modelColumnIndexMap = new LinkedHashMap<Integer, String>();
        LinkedHashMap modelPropertyTypeMap = new LinkedHashMap();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            String fieldTitle = "";
            Integer fieldIndex = -1;
            boolean excelColumnAnnotation = field.isAnnotationPresent(ExcelColumn.class);
            if (!excelColumnAnnotation) continue;
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            fieldTitle = excelColumn.title();
            fieldIndex = excelColumn.index();
            if (fieldIndex != null && fieldIndex > -1) {
                modelColumnIndexMap.put(fieldIndex, fieldName);
            } else if (!StringUtils.isEmpty((Object)fieldTitle)) {
                modelColumnTitleMap.put(fieldTitle, fieldName);
            }
            modelPropertyTypeMap.put(fieldName, fieldType);
        }
        excelModel.setModelColumnTitleMap(modelColumnTitleMap);
        excelModel.setModelColumnIndexMap(modelColumnIndexMap);
        excelModel.setModelPropertyTypeMap(modelPropertyTypeMap);
    }

    public static synchronized Sheet findDataSheet(Workbook workbook, ExcelModel excelModel) {
        Sheet sheet = null;
        if (excelModel == null) {
            log.error("\u8bfb\u53d6Workbook\u5931\u8d25\uff0c\u539f\u56e0\u662fExcelModel\u4e3a\u7a7a");
            return sheet;
        }
        if (excelModel.getSheetIndex() != null && excelModel.getSheetIndex() > -1) {
            sheet = workbook.getSheetAt(excelModel.getSheetIndex().intValue());
        }
        if (sheet == null && !StringUtils.isEmpty((Object)excelModel.getSheetName())) {
            sheet = workbook.getSheet(excelModel.getSheetName());
        }
        if (sheet == null) {
            log.warn("\u672a\u80fd\u4ece\u5de5\u4f5c\u7c3f\u4e2d\u6210\u529f\u8bfb\u53d6\u5230sheet\u8868\u683c\uff0c\u8bf7\u6838\u5bf9\u8868\u683c\u7684\u53c2\u6570\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)excelModel));
        }
        return sheet;
    }

    public static synchronized void findColumnTitle(Row row, ExcelModel excelModel) {
        Map<Integer, String> excelColumnTitleMap = excelModel.getExcelColumnTitleMap();
        if (excelColumnTitleMap == null) {
            excelColumnTitleMap = new LinkedHashMap<Integer, String>();
        }
        for (int i = 0; i <= row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            Integer n = ExcelUtils.findCellType(cell);
        }
    }

    public static synchronized Integer findCellType(Cell cell) {
        if (cell == null) {
            return null;
        }
        int type = -1;
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case _NONE: {
                type = -1;
                break;
            }
            case NUMERIC: {
                type = 0;
                break;
            }
            case STRING: {
                type = 1;
                break;
            }
            case FORMULA: {
                type = 2;
                break;
            }
            case BLANK: {
                type = 3;
                break;
            }
            case BOOLEAN: {
                type = 4;
                break;
            }
            case ERROR: {
                type = 5;
                break;
            }
            default: {
                type = -1;
            }
        }
        return type;
    }

    public static synchronized Object findCellValue(Cell cell, Integer cellType) {
        if (cell == null || cellType == null) {
            return null;
        }
        Object value = null;
        switch (cellType) {
            case -1: {
                value = null;
                log.error("\u65e0\u6cd5\u83b7\u53d6\u5230\u5355\u5143\u683c {} \u884c {} \u5217 \u4e2d\u7684\u5185\u5bb9\uff0c\u539f\u56e0\u662f\u8be5\u5355\u5143\u683c\u7684\u7c7b\u578b\u672a\u77e5", (Object)(cell.getAddress().getRow() + 1), (Object)(cell.getAddress().getColumn() + 1));
                break;
            }
            case 0: {
                value = cell.getNumericCellValue();
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 2: {
                int a = cell.getCellFormula().indexOf("+") + 1 + (cell.getCellFormula().indexOf(45) + 1) + (cell.getCellFormula().indexOf(42) + 1) + (cell.getCellFormula().indexOf(47) + 1);
                if (a <= 0) {
                    value = cell.getCellFormula();
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 4: {
                value = new Boolean(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = new Byte(cell.getErrorCellValue());
                break;
            }
            default: {
                value = null;
                log.error("\u65e0\u6cd5\u83b7\u53d6\u5230\u5355\u5143\u683c {} \u884c {} \u5217 \u4e2d\u7684\u5185\u5bb9\uff0c\u539f\u56e0\u662f\u8be5\u5355\u5143\u683c\u7684\u7c7b\u578b\u9519\u8bef", (Object)(cell.getAddress().getRow() + 1), (Object)(cell.getAddress().getColumn() + 1));
            }
        }
        return value;
    }

    public static synchronized <T> T findCellValue(Object value, Class<?> clazz) {
        return null;
    }
}

