/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.config;

import com.github.bootfastconfig.abnormal.ServiceRuntimeException;
import com.github.bootfastconfig.result.L18nResultCode;
import com.github.bootfastconfig.result.Result;
import com.github.bootfastconfig.result.ResultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order
@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={ServiceRuntimeException.class})
    @ResponseBody
    public Result handleWJException(ServiceRuntimeException e) {
        LOGGER.error("\u6355\u6349\u5230\u5f02\u5e38*****", (Throwable)e);
        return Result.ofFail((ResultCode)new L18nResultCode(e.getResultCode()));
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result handleException(Exception e) {
        LOGGER.error("\u6355\u6349\u5230\u5f02\u5e38*****", (Throwable)e);
        return Result.ofFail();
    }
}

