/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.bootfastconfig.annotation.HeaderParam;
import com.github.bootfastconfig.annotation.JsonParam;
import com.github.bootfastconfig.springtool.WebUtil;
import com.github.bootfastconfig.web.WebData;
import com.github.bootfastconfig.web.WebdDtaContainer;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class JsonPathArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathArgumentResolver.class);
    private static final String JSON_REQUEST_BODY = "$_JSON_REQUEST_BODY_$";
    private final Configuration conf;

    protected JsonPathArgumentResolver() {
        Configuration configuration = Configuration.defaultConfiguration();
        this.conf = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL, Option.SUPPRESS_EXCEPTIONS});
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(JsonParam.class) || parameter.hasParameterAnnotation(HeaderParam.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (parameter.hasParameterAnnotation(HeaderParam.class)) {
            return this.resolveArgumentHeaderParam(parameter, mavContainer, webRequest, binderFactory);
        }
        return this.resolveArgumentJsonParam(parameter, mavContainer, webRequest, binderFactory);
    }

    private Object resolveArgumentJsonParam(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object arg = this.readWithMessageConverters(parameter, webRequest);
        String name = Conventions.getVariableNameForParameter((MethodParameter)parameter);
        if (binderFactory != null) {
            WebDataBinder binder = binderFactory.createBinder(webRequest, arg, name);
            if (arg != null) {
                this.validateIfApplicable(binder, parameter);
                if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                    throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
                }
            }
            if (mavContainer != null) {
                mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + name, (Object)binder.getBindingResult());
            }
        }
        return arg;
    }

    private Object resolveArgumentHeaderParam(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String name = parameter.getParameterName();
        HeaderParam headerParam = (HeaderParam)parameter.getParameterAnnotation(HeaderParam.class);
        if (!StringUtils.isEmpty((Object)headerParam.value())) {
            name = headerParam.value();
        }
        Class parameterType = parameter.getParameterType();
        String[] headerValues = webRequest.getHeaderValues(name);
        if (headerValues == null) {
            return null;
        }
        if (parameterType == String.class && headerValues.length == 1) {
            return headerValues[0];
        }
        String jsonData = this.objectToString(headerValues);
        return this.objectToClassTypeObject(parameterType, jsonData);
    }

    private void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            binder.validate(validationHints);
            break;
        }
    }

    private boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    private Object readWithMessageConverters(MethodParameter parameter, NativeWebRequest webRequest) throws IOException {
        String name = parameter.getParameterName();
        JsonParam jsonParam = (JsonParam)parameter.getParameterAnnotation(JsonParam.class);
        if (!StringUtils.isEmpty((Object)jsonParam.value())) {
            name = jsonParam.value();
        }
        Class clazz = parameter.getParameterType();
        String jsonData = this.getData(webRequest, name);
        if (jsonData == null) {
            this.IsNull(jsonParam, clazz);
            return null;
        }
        Object val = this.getJsonPath(jsonData, name);
        if (val == null && jsonData != null) {
            val = webRequest.getParameter(name);
        }
        if (val == null) {
            this.IsNull(jsonParam, clazz);
            return null;
        }
        Class parameterType = parameter.getParameterType();
        Object arg = this.objectToClassTypeObject(parameterType, val);
        if (arg == null) {
            this.IsNull(jsonParam, clazz);
            return null;
        }
        WebdDtaContainer.setWebData((WebData)new WebData(parameter, arg, val.getClass() == String.class ? (String)val : this.objectToString(val)));
        return arg;
    }

    public Object objectToClassTypeObject(Class c, Object r) throws JsonProcessingException {
        if (r == null) {
            return null;
        }
        if (c.isAssignableFrom(r.getClass())) {
            return r;
        }
        if (c == String.class) {
            if (!(r instanceof String)) {
                r = this.objectToString(r);
            }
            return r;
        }
        r = this.JsonStringToObject(c, r.getClass() == String.class ? (String)r : this.objectToString(r));
        return r;
    }

    public abstract Object JsonStringToObject(Class<?> var1, String var2);

    public abstract String objectToString(Object var1) throws JsonProcessingException;

    public abstract <T> T inputStreamToc(InputStream var1, Class<T> var2) throws IOException;

    public Object getJsonPath(String jsonData, String name) {
        Object val = null;
        try {
            val = JsonPath.using((Configuration)this.conf).parse(jsonData).read(name, new Predicate[0]);
        }
        catch (PathNotFoundException | IllegalArgumentException e) {
            LOGGER.error("\u5165\u53c2\u89e3\u6790\u5668\u51fa\u9519 \u5728json \u4e3a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u503c ", e);
        }
        return val;
    }

    private String getData(NativeWebRequest webRequest, String name) throws IOException {
        HttpServletRequest servletRequest;
        String jsonData = webRequest.getParameter(name);
        if (jsonData == null && (jsonData = (String)(servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getAttribute(JSON_REQUEST_BODY)) == null && (jsonData = webRequest.getParameter(JSON_REQUEST_BODY)) == null) {
            jsonData = WebUtil.getRequestInputStreamStr((HttpServletRequest)servletRequest);
            servletRequest.setAttribute(JSON_REQUEST_BODY, (Object)jsonData);
        }
        return jsonData;
    }

    public void IsNull(JsonParam jsonParam, Class clazz) {
        if (jsonParam.required()) {
            throw new NullPointerException("");
        }
    }
}

