/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.config;

import com.github.bootfastconfig.expand.MessageSource;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class MessageSourceConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MessageSourceConfiguration.class);

    @Bean
    @ConditionalOnBean(value={MessageSource.class})
    public org.springframework.context.MessageSource messageSource(MessageSource properties) {
        return new MyMessageSourceService(properties);
    }

    public class MyMessageSourceService
    extends AbstractMessageSource
    implements ResourceLoaderAware {
        private MessageSource messageSource;
        private ResourceLoader resourceLoader;

        public MyMessageSourceService(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public String getSourceFromCache(String code, Locale locale) {
            Map<String, String> props = this.messageSource.getMessageByLocale(code, locale);
            if (null != props && props.containsKey(code)) {
                return props.get(code);
            }
            try {
                if (null != this.getParentMessageSource()) {
                    return this.getParentMessageSource().getMessage(code, null, locale);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            return code;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader == null ? new DefaultResourceLoader() : resourceLoader;
        }

        protected String resolveCodeWithoutArguments(String code, Locale locale) {
            return this.getSourceFromCache(code, locale);
        }

        protected MessageFormat resolveCode(String code, Locale locale) {
            String msg = this.getSourceFromCache(code, locale);
            MessageFormat messageFormat = new MessageFormat(msg, locale);
            return messageFormat;
        }
    }
}

