/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.config;

import com.github.bootfastconfig.config.PropertiesNativeAsyncTaskExecutePoolCfig;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

@Configuration
public class NativeAsyncTaskExecutePool
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(NativeAsyncTaskExecutePool.class);
    @Autowired
    private PropertiesNativeAsyncTaskExecutePoolCfig nativeAsyncTaskExecuteCfig;

    public Executor getAsyncExecutor() {
        VisiableThreadPoolTaskExecutor executor = new VisiableThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.nativeAsyncTaskExecuteCfig.getCorePoolSize());
        executor.setMaxPoolSize(this.nativeAsyncTaskExecuteCfig.getMaxPoolSize());
        executor.setQueueCapacity(this.nativeAsyncTaskExecuteCfig.getQueueCapacity());
        executor.setKeepAliveSeconds(this.nativeAsyncTaskExecuteCfig.getKeepAliveSeconds());
        executor.setThreadNamePrefix(this.nativeAsyncTaskExecuteCfig.getThreadNamePrefix());
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (arg0, arg1, arg2) -> {
            log.error("==========================" + arg0.getMessage() + "=======================", arg0);
            log.error("exception method:" + arg1.getName());
        };
    }

    public class VisiableThreadPoolTaskExecutor
    extends ThreadPoolTaskExecutor {
        private final Logger logger = LoggerFactory.getLogger(VisiableThreadPoolTaskExecutor.class);

        private void showThreadPoolInfo(String prefix) {
            ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
            if (null == threadPoolExecutor) {
                return;
            }
            this.logger.info(MessageFormat.format("{0}, {1},taskCount [{2}], completedTaskCount [{3}], activeCount [{4}], queueSize [{5}]", this.getThreadNamePrefix(), prefix, threadPoolExecutor.getTaskCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getActiveCount(), threadPoolExecutor.getQueue().size()));
        }

        public void execute(Runnable task) {
            this.showThreadPoolInfo("1. do execute");
            super.execute(task);
        }

        public void execute(Runnable task, long startTimeout) {
            this.showThreadPoolInfo("2. do execute");
            super.execute(task, startTimeout);
        }

        public Future<?> submit(Runnable task) {
            this.showThreadPoolInfo("1. do submit");
            return super.submit(task);
        }

        public <T> Future<T> submit(Callable<T> task) {
            this.showThreadPoolInfo("2. do submit");
            return super.submit(task);
        }

        public ListenableFuture<?> submitListenable(Runnable task) {
            this.showThreadPoolInfo("1. do submitListenable");
            return super.submitListenable(task);
        }

        public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
            this.showThreadPoolInfo("2. do submitListenable");
            return super.submitListenable(task);
        }
    }
}

