/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.config;

import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@ConditionalOnClass(value={Aspect.class, AspectJExpressionPointcut.class, DataSourceTransactionManager.class})
@Order
@Aspect
@ConditionalOnProperty(prefix="fastconfig", name={"transactionAdvice"}, havingValue="true")
public class TransactionAdviceConfig {
    private static final String AOP_POINTCUT_EXPRESSION = "execution (* com.***.service.*.*(..))";
    private static final String[] write = new String[]{"add*", "save*", "delete*", "update*", "exec*", "set*", "import*", "del*"};
    private static final String[] read = new String[]{"get*", "query*", "find*", "list*", "count*", "is*", "export*"};
    @Resource(name="txManager")
    private PlatformTransactionManager txManager2;

    @Bean(value={"txManager"})
    public PlatformTransactionManager annotationDrivenTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(value={"transactionAdviceConfig"})
    public TransactionManagementConfigurer getTransactionManagementConfigurer(final @Qualifier(value="txManager") PlatformTransactionManager transactionManager) {
        return new TransactionManagementConfigurer(){

            public PlatformTransactionManager annotationDrivenTransactionManager() {
                return transactionManager;
            }
        };
    }

    @Bean(value={"txAdvice"})
    public TransactionInterceptor txAdvice(@Qualifier(value="txManager") PlatformTransactionManager transactionManager) {
        DefaultTransactionAttribute txAttr_REQUIRED = new DefaultTransactionAttribute();
        txAttr_REQUIRED.setPropagationBehavior(0);
        DefaultTransactionAttribute txAttr_REQUIRED_READONLY = new DefaultTransactionAttribute();
        txAttr_REQUIRED_READONLY.setPropagationBehavior(0);
        txAttr_REQUIRED_READONLY.setReadOnly(true);
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        Stream.of(write).forEach(o -> source.addTransactionalMethod(o, (TransactionAttribute)txAttr_REQUIRED));
        Stream.of(read).forEach(o -> source.addTransactionalMethod(o, (TransactionAttribute)txAttr_REQUIRED_READONLY));
        return new TransactionInterceptor(transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor(@Qualifier(value="txAdvice") TransactionInterceptor txAdvice) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(AOP_POINTCUT_EXPRESSION);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)txAdvice);
    }
}

