/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.config;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private HttpMessageConverter myhttpMessageConverter;

    public Validator getValidator() {
        return this.validator();
    }

    @Bean
    public LocalValidatorFactoryBean validator() {
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        validator.setValidationMessageSource(this.messageSource);
        return validator;
    }

    @Bean
    public StringHttpMessageConverter messageConverter() {
        return new StringHttpMessageConverter(StandardCharsets.UTF_8);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        Iterator<HttpMessageConverter<?>> iterator = converters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter<?> converter = iterator.next();
            if (!(converter instanceof StringHttpMessageConverter)) continue;
            iterator.remove();
        }
        converters.add(this.myhttpMessageConverter);
    }
}

