/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.github.bootfastconfig.expand.AnnotationJson;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration(value="AnnotationJackson")
public class AnnotationJackson
extends Module
implements ApplicationContextAware {
    public static final String ARTIFACT_ID = "jackson-AnnotationJackson";
    public static final Version VERSION = new Version(1, 0, 0, null, null, null);
    private Map<Class, AnnotationJson> sysAnnotationJson;

    public String getModuleName() {
        return ARTIFACT_ID;
    }

    public Version version() {
        return VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        context.addBeanSerializerModifier((BeanSerializerModifier)new BeanSerializerModifierAnnotation());
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new BeanDeserializerModifierAnnotation());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beansOfType = applicationContext.getBeansOfType(AnnotationJson.class);
        this.sysAnnotationJson = new HashMap<Class, AnnotationJson>(16);
        beansOfType.values().stream().forEach(o -> this.sysAnnotationJson.put(o.getAnnotationClass(), (AnnotationJson)o));
    }

    public class BeanSerializerModifierAnnotation
    extends BeanSerializerModifier {
        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            return beanProperties.stream().map(writer -> {
                if (writer == null && writer.getMember() == null && writer.getMember().getAllAnnotations() == null && writer.getMember().getAllAnnotations().annotations() == null) {
                    return writer;
                }
                Iterator annotations = writer.getMember().getAllAnnotations().annotations().iterator();
                if (annotations == null) {
                    return writer;
                }
                while (annotations.hasNext()) {
                    Annotation annotation = (Annotation)annotations.next();
                    AnnotationJson annotationJson = (AnnotationJson)AnnotationJackson.this.sysAnnotationJson.get(annotation.annotationType());
                    if (annotationJson == null) continue;
                    annotationJson.changeProperties(config, beanDesc, beanProperties, (BeanPropertyWriter)writer, annotation);
                }
                return writer;
            }).collect(Collectors.toList());
        }
    }

    public class BeanDeserializerModifierAnnotation
    extends BeanDeserializerModifier {
        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            Iterator beanPropertyIterator = builder.getProperties();
            beanPropertyIterator.forEachRemaining(settableBeanProperty -> {
                if (settableBeanProperty.getMember() == null) {
                    return;
                }
                if (settableBeanProperty.getMember().getAllAnnotations() == null) {
                    return;
                }
                Iterable allAnnotations = settableBeanProperty.getMember().getAllAnnotations().annotations();
                if (allAnnotations == null) {
                    return;
                }
                for (Annotation annotation : allAnnotations) {
                    AnnotationJson annotationJson = (AnnotationJson)AnnotationJackson.this.sysAnnotationJson.get(annotation.annotationType());
                    if (annotationJson == null) continue;
                    annotationJson.updateBuilder(config, beanDesc, builder, (SettableBeanProperty)settableBeanProperty, annotation);
                }
            });
            return builder;
        }
    }
}

