/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.github.bootfastconfig.expand.AnnotationJson;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;

public abstract class BaseSimpleAnnotationJson<T extends Annotation>
implements AnnotationJson<T> {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder, final SettableBeanProperty settableBeanProperty, T annotation) {
        SettableBeanProperty newSettableBeanProperty = settableBeanProperty.withValueDeserializer(new JsonDeserializer((Annotation)annotation){
            final /* synthetic */ Annotation val$annotation;
            {
                this.val$annotation = annotation;
            }

            public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return BaseSimpleAnnotationJson.this.deserializ(p, settableBeanProperty, this.val$annotation);
            }
        });
        builder.addOrReplaceProperty(newSettableBeanProperty, true);
    }

    public Object deserializ(JsonParser p, SettableBeanProperty settableBeanProperty, T annotation) throws IOException {
        JsonStreamContext parsingContext;
        Class rawClass = settableBeanProperty.getType().getRawClass();
        Object o = this.objectMapper.readValue(p, rawClass);
        if (o instanceof String) {
            String a = (String)o;
            while (a.startsWith("\"")) {
                a = a.substring(1, a.length()).trim();
            }
            while (a.endsWith("\"")) {
                a = a.substring(0, a.length() - 1).trim();
            }
            o = a;
        }
        return this.deserialize((parsingContext = p.getParsingContext()) != null ? parsingContext.getCurrentValue() : null, parsingContext != null ? parsingContext.getCurrentName() : null, o, annotation);
    }

    public abstract Object deserialize(Object var1, String var2, Object var3, T var4) throws JsonProcessingException;

    @Override
    public abstract Object serialization(Object var1, String var2, Object var3, T var4);

    public String serialization(JsonGenerator jsonGenerator, Object o, T annotation) throws JsonProcessingException {
        JsonStreamContext outputContext = jsonGenerator.getOutputContext();
        Object serialization = this.serialization(outputContext != null ? outputContext.getCurrentValue() : null, outputContext != null ? outputContext.getCurrentName() : null, o, annotation);
        if (serialization instanceof String) {
            return (String)serialization;
        }
        return serialization == null ? null : this.objectMapper.writeValueAsString(serialization);
    }

    @Override
    public void changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties, BeanPropertyWriter writer, final T annotation) {
        writer.assignSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(BaseSimpleAnnotationJson.this.serialization(jsonGenerator, o, annotation));
            }
        });
    }
}

