/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.bootfastconfig.config.JsonPathArgumentResolver;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonParam
extends JsonPathArgumentResolver {
    private final Logger LOGGER = LoggerFactory.getLogger(JacksonJsonParam.class);
    private final ObjectMapper objectMapper;

    public JacksonJsonParam(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Object JsonStringToObject(Class<?> c, String val) {
        if (c == String.class) {
            return val;
        }
        try {
            return this.objectMapper.readValue(val, c);
        }
        catch (IOException e) {
            this.LOGGER.error("JacksonJsonParamimpl ..... \u5165\u53c2\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    @Override
    public String objectToString(Object o) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(o);
    }

    @Override
    public <T> T inputStreamToc(InputStream inputStream, Class<T> c) throws IOException {
        if (c == String.class) {
            return (T)this.objectToString(this.objectMapper.readValue(inputStream, Object.class));
        }
        return (T)this.objectMapper.readValue(inputStream, c);
    }
}

