/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.bootfastconfig.annotation.ResponseResult;
import com.github.bootfastconfig.result.Result;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order
@ControllerAdvice
@ConditionalOnClass(value={ObjectMapper.class})
public class JsonHttpMessageConverter
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LogManager.getLogger(JsonHttpMessageConverter.class);
    @Autowired
    private ObjectMapper mapper;

    public boolean supports(MethodParameter returnType, Class converterType) {
        if (converterType == StringHttpMessageConverter.class) {
            return true;
        }
        return converterType == MappingJackson2HttpMessageConverter.class;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (AnnotationUtils.findAnnotation((Class)returnType.getDeclaringClass(), ResponseResult.class) == null && returnType.getMethodAnnotation(ResponseResult.class) == null) {
            return body;
        }
        Result result = Result.ofSuccess((Object)body);
        if (selectedConverterType == StringHttpMessageConverter.class) {
            try {
                return this.mapper.writeValueAsString((Object)result);
            }
            catch (JsonProcessingException e) {
                log.error("\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff1aStringHttpMessageConverter \u3002\u3002\u3002\u3002 beforeBodyWrite ", (Throwable)e);
                e.printStackTrace();
            }
        }
        return result;
    }
}

