/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.xss;

import com.github.bootfastconfig.xss.JsoupXssFormat;
import com.github.bootfastconfig.xss.XssFilter;
import com.github.bootfastconfig.xss.XssFormat;
import com.github.bootfastconfig.xss.XssProperties;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

public class XssConfig {
    @Autowired
    private XssProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={XssFormat.class})
    public XssFormat getXssFormat() {
        return new JsoupXssFormat();
    }

    @Bean
    public FilterRegistrationBean xssFilterRegistrationBean(XssFormat format) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new XssFilter(format));
        filterRegistrationBean.setOrder(Integer.MAX_VALUE);
        filterRegistrationBean.setEnabled(true);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        HashMap initParameters = Maps.newHashMap();
        initParameters.put("excludes", this.properties.getExcludesString());
        filterRegistrationBean.setInitParameters((Map)initParameters);
        return filterRegistrationBean;
    }
}

