/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.xss;

import com.github.bootfastconfig.springtool.StringUtil;
import com.github.bootfastconfig.xss.XssFormat;
import com.github.bootfastconfig.xss.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(XssFilter.class);
    public String[] excludes;
    private XssFormat xssFormat;

    public XssFilter(XssFormat format) {
        this.xssFormat = format;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse resp;
        HttpServletRequest req;
        if (logger.isDebugEnabled()) {
            logger.debug("xss filter is open");
        }
        if (this.handleExcludeURL(req = (HttpServletRequest)request, resp = (HttpServletResponse)response)) {
            filterChain.doFilter(request, response);
            return;
        }
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request, this.xssFormat);
        filterChain.doFilter((ServletRequest)xssRequest, response);
    }

    private boolean handleExcludeURL(HttpServletRequest request, HttpServletResponse response) {
        if (this.excludes == null || this.excludes.length == 0) {
            return false;
        }
        String url = request.getServletPath();
        for (String pattern : this.excludes) {
            Pattern p = Pattern.compile("^" + pattern);
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String[] url;
        String temp;
        if (logger.isDebugEnabled()) {
            logger.debug("xss filter init~~~~~~~~~~~~");
        }
        if (StringUtil.isEmpty((Object)(temp = filterConfig.getInitParameter("excludes"))) && (url = temp.split(",")) != null && url.length > 0) {
            this.excludes = url;
        }
    }

    public void destroy() {
    }
}

