/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.xss;

import com.github.bootfastconfig.springtool.StringUtil;
import com.github.bootfastconfig.springtool.WebUtil;
import com.github.bootfastconfig.xss.RepeatServletInputStream;
import com.github.bootfastconfig.xss.XssFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest orgRequest;
    private XssFormat xssFormat;
    private RepeatServletInputStream repeatServletInputStream;

    public XssHttpServletRequestWrapper(HttpServletRequest request, XssFormat format) throws IOException {
        super(request);
        this.orgRequest = request;
        this.xssFormat = format;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest request) {
        return request instanceof XssHttpServletRequestWrapper ? ((XssHttpServletRequestWrapper)request).getOrgRequest() : request;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private ServletInputStream servletInputStreamAutomaticConstructor(byte[] data) throws IOException {
        if (this.repeatServletInputStream == null) {
            this.repeatServletInputStream = data == null || data.length < 0 ? new RepeatServletInputStream((InputStream)super.getInputStream()) : new RepeatServletInputStream(data);
        } else {
            this.repeatServletInputStream.reset();
        }
        return this.repeatServletInputStream;
    }

    public ServletInputStream getInputStream() throws IOException {
        String requestStr;
        if (null == super.getHeader("Content-Type")) {
            return this.servletInputStreamAutomaticConstructor(null);
        }
        if (!(super.getHeader("Content-Type").equalsIgnoreCase("application/json") || super.getHeader("Content-Type").equalsIgnoreCase("application/json;charset=UTF-8") || super.getHeader("Content-Type").equalsIgnoreCase("application/json; charset=UTF-8"))) {
            return this.servletInputStreamAutomaticConstructor(null);
        }
        if (this.repeatServletInputStream == null && !StringUtil.isBlank((CharSequence)(requestStr = WebUtil.getRequestInputStreamStr((HttpServletRequest)this.orgRequest)))) {
            requestStr = this.xssFormat.inputStreamFormat(requestStr);
            return this.servletInputStreamAutomaticConstructor(requestStr.getBytes(Charset.forName("UTF-8")));
        }
        return this.servletInputStreamAutomaticConstructor(null);
    }

    public String getParameter(String name) {
        String value = super.getParameter(this.xssEncode(name));
        if (StringUtil.isNotBlank((CharSequence)value)) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] parameters = super.getParameterValues(name);
        if (parameters != null && parameters.length != 0) {
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.xssEncode(parameters[i]);
            }
            return parameters;
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        Map parameters = super.getParameterMap();
        for (String key : parameters.keySet()) {
            String[] values = (String[])parameters.get(key);
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.xssEncode(values[i]);
            }
            map.put(key, values);
        }
        return map;
    }

    public String getHeader(String name) {
        String value = super.getHeader(this.xssEncode(name));
        if (StringUtil.isNotBlank((CharSequence)value)) {
            value = this.xssEncode(value);
        }
        return value;
    }

    private String xssEncode(String input) {
        return this.xssFormat.parameterFormat(input);
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }
}

